/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.example.mdr.registration.internal.core.ISampleCMDBConstants;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDBUtil;

/**
 * The instance id handler for item templates included in a 
 * query request sent to this federating CMDB.
 * 
 * @author Ali Mehregani
 */
public class CMDBItemInstanceIdHandler extends AbstractItemConstraintHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemConstraintHandler#handle(org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes, org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint)
	 */
	@Override
	protected INodes handle(INodes context, IConstraint constraint) throws CMDBfServiceException
	{
		return (INodes) SampleFederatingCMDBUtil.handleInstanceIdConstraint(
							(SampleFederatingCMDB)getValue(ISampleCMDBConstants.DATA_PROVIDER), 
							context, 
							((IInstanceIdConstraint)constraint).getInstanceIds(), true);		
	}

	

}
