/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.query;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.example.mdr.registration.internal.core.ISampleCMDBConstants;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;

/**
 * The item template handler for the sample federating CMDB
 * 
 * @author Ali Mehregani
 */
public class CMDBItemTemplateHandler extends AbstractItemTemplateHandler
{
	@Override
	protected void appendAllItems(INodes nodes) throws CMDBfServiceException
	{
		SampleFederatingCMDB federatingCMDB = (SampleFederatingCMDB)getValue(ISampleCMDBConstants.DATA_PROVIDER);
		Map<String, Map<String, IGraphElement>> items = federatingCMDB.retrieveItemsMap();
		
		for (Iterator<String> mdrIds = items.keySet().iterator(); mdrIds.hasNext();)
		{
			Map<String, IGraphElement> elements = items.get(mdrIds.next());
			for (Iterator<String> localIds = elements.keySet().iterator(); localIds.hasNext();)
			{
				nodes.addElement(elements.get(localIds.next()));				
			}			
		}
	}
}
