/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IItemTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IQueryHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandlerFactory;

/**
 * The handler factory for the federating CMDB query service.
 * This is a singleton class that should be accessed via {@link #getInstance()}
 *  
 * @author Ali Mehregani
 */
public class CMDBQueryHandlerFactory extends AbstractQueryHandlerFactory
{
	private static CMDBQueryHandlerFactory instance;
	
	
	/**
	 * Returns the instance of this singleton class
	 * 
	 * @return A static instance of this class
	 */
	public static IQueryHandlerFactory getInstance()
	{
		if (instance == null)
		{
			instance = new CMDBQueryHandlerFactory();
		}
		return instance;
	}
	
	
	/**
	 * Constructor - restrict the visibility
	 */
	private CMDBQueryHandlerFactory()
	{
		
	}
	
	@Override
	protected IItemTemplateHandler createItemHandler() throws CMDBfServiceException
	{	
		return new CMDBItemTemplateHandler();
	}
	
	@Override
	protected IItemConstraintHandler createItemInstanceHandler() throws CMDBfServiceException
	{
		return new CMDBItemInstanceIdHandler();
	}
	
	@Override
	protected IRelationshipTemplateHandler createRelationshipHandler() throws CMDBfServiceException
	{
		return new CMDBRelationshipTemplateHandler();
	}
	
	@Override
	protected IRelationshipConstraintHandler createRelationshipInstanceHandler() throws CMDBfServiceException
	{
		return new CMDBRelationshipInstanceIdHandler();
	}
}
