/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.query;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractRelationshipConstraintHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IInstanceIdConstraint;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.example.mdr.registration.internal.core.ISampleCMDBConstants;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDBUtil;

/**
 * The instance id handler for relationship templates.
 * 
 * @author Ali Mehregani
 */
public class CMDBRelationshipInstanceIdHandler extends AbstractRelationshipConstraintHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractRelationshipConstraintHandler#handle(org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges, org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IConstraint)
	 */
	@Override
	protected IEdges handle(IEdges context, IConstraint constraint) throws CMDBfServiceException
	{
		return (IEdges) SampleFederatingCMDBUtil.handleInstanceIdConstraint(
				(SampleFederatingCMDB)getValue(ISampleCMDBConstants.DATA_PROVIDER), 
				context, 
				((IInstanceIdConstraint)constraint).getInstanceIds(), false);		
	}
}
