/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.query;

import java.util.List;
import java.util.Map;

import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.service.impl.AbstractQueryHandler;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.example.mdr.registration.internal.core.ISampleCMDBConstants;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDBUtil;

/**
 * The relationship template handler for the query service
 * of the federating CMDB.  Depth limit and cardinality are
 * not supported.
 * 
 * @author Ali Mehregani
 */
public class CMDBRelationshipTemplateHandler extends AbstractQueryHandler implements IRelationshipTemplateHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.query.service.IRelationshipTemplateHandler#execute(org.eclipse.cosmos.dc.cmdbf.services.query.transform.response.artifacts.IQueryResult, org.eclipse.cosmos.dc.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate, org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem, org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem)
	 */
	public IEdges execute(IQueryResult context, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException
	{
		SampleFederatingCMDB repository = (SampleFederatingCMDB)getValue(ISampleCMDBConstants.DATA_PROVIDER);
		Map<IInstanceId, List<IRelationship>> relationships = repository.retrieveRelationshipBySource();
		IEdges edges = QueryOutputArtifactFactory.getInstance().createEdges(relationshipTemplate.getId());
		
		
		// For each instance id of the source item
		IInstanceId[] sourceInstanceIds = source.getInstanceIds();
		for (int i = 0; i < sourceInstanceIds.length; i++)
		{
			// Determine if source has any relationship with the target element
			List<IRelationship> relationshipList = relationships.get(sourceInstanceIds[i]);
			if (relationshipList == null)
			{
				continue;
			}
			
			for (int j = 0, relationshipCount = relationshipList.size(); j < relationshipCount; j++)
			{
				if (SampleFederatingCMDBUtil.isEqual(new IInstanceId[]{relationshipList.get(j).getTargetId()}, target.getInstanceIds(), true))
				{
					edges.addRelationship(relationshipList.get(j));
				}				
			}
		}
		
		return edges;
	}
}
