/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.service;

import org.eclipse.cosmos.dc.cmdbf.services.common.AbstractItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.example.mdr.registration.internal.core.ISampleCMDBConstants;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;

/**
 * An item notification handler used for a registration/deregistration
 * requests.
 * 
 * @author Ali Mehregani
 */
public class CMDBItemNotificationHandler extends AbstractItemNotificationHandler
{

	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.AbstractItemNotificationHandler#handleItem(int, org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IItem)
	 */
	@Override
	public String handleItem(int type, IItem item)
	{
		return process ((SampleFederatingCMDB)getValue(ISampleCMDBConstants.DATA_PROVIDER), type, item, true);
	}
	
	
	protected static String process (SampleFederatingCMDB repository, int type, IGraphElement element, boolean isItem)
	{
		switch (type)
		{
			case INotificationHandler.REGISTRATION:
								
				// Add the element
				repository.addElement(element, isItem);				
				break;
				
			case INotificationHandler.DEREGISTRATION:
				
				// Remove the element
				repository.removeElement (element, isItem);
				break;
		}

		return null;
	}
}
