/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.service;

import org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.cmdbf.services.common.IItemNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.cmdbf.services.common.IRelationshipNotificationHandler;

/**
 * The notification handler factory used for creating handlers to
 * process registration/deregistration requests
 * 
 * @author Ali Mehregani
 */
public class CMDBNotificationHandlerFactory extends AbstractNotificationHandlerFactory
{
	/**
	 * The instace of this class
	 */
	private static INotificationHandlerFactory instance;
	
	/**
	 * Retrieves and returns the instance of this singleton
	 * class.
	 * 
	 * @return The static instance of this class
	 */
	public static INotificationHandlerFactory getInstance()
	{
		if (instance == null)
		{
			instance = new CMDBNotificationHandlerFactory();
		}
		return instance;
	}
	
	
	/**
	 * Restrict the visibility of this class
	 */
	private CMDBNotificationHandlerFactory()
	{
		
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationHandlerFactory#createRegistrationItemHandler()
	 */
	@Override
	protected IItemNotificationHandler createRegistrationItemHandler() throws CMDBfServiceException
	{		
		return new CMDBItemNotificationHandler();
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationHandlerFactory#createDeregistrationItemHandler()
	 */
	@Override
	protected IItemNotificationHandler createDeregistrationItemHandler() throws CMDBfServiceException
	{
		return new CMDBItemNotificationHandler();
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationHandlerFactory#createRegistrationRelationshipHandler()
	 */
	@Override
	protected IRelationshipNotificationHandler createRegistrationRelationshipHandler() throws CMDBfServiceException
	{
		return new CMDBRelationshipNotificationHandler();
	}
	
	
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.AbstractNotificationHandlerFactory#createDeregistrationRelationshipHandler()
	 */
	@Override
	protected IRelationshipNotificationHandler createDeregistrationRelationshipHandler() throws CMDBfServiceException
	{
		return new CMDBRelationshipNotificationHandler();
	}
}
