/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.example.mdr.registration.internal.service;

import org.eclipse.cosmos.dc.cmdbf.services.common.AbstractRelationshipNotificationHandler;
import org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.example.mdr.registration.internal.core.ISampleCMDBConstants;
import org.eclipse.cosmos.example.mdr.registration.internal.core.SampleFederatingCMDB;

/**
 * A relationship notification handler used for a registration/deregistration
 * requests.
 * 
 * @author Ali Mehregani
 */
public class CMDBRelationshipNotificationHandler extends AbstractRelationshipNotificationHandler
{
	/**
	 * @see org.eclipse.cosmos.dc.cmdbf.services.common.AbstractRelationshipNotificationHandler#handleRelationship(int, org.eclipse.cosmos.dc.cmdbf.services.transform.artifacts.IRelationship)
	 */
	@Override
	public String handleRelationship(int type, IRelationship relationship)
	{
		return CMDBItemNotificationHandler.process ((SampleFederatingCMDB)getValue(ISampleCMDBConstants.DATA_PROVIDER), type, relationship, false);
	}

}
