/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.internal.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Groups;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Services;
import org.eclipse.cosmos.dc.broker.provisional.persistence.BrokerDatabase;
import org.eclipse.cosmos.dc.broker.provisional.persistence.BrokerDatabaseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerDatabaseImpl
implements BrokerDatabase {
    private static File databaseDir = null;
    private static File databaseFile = null;
    private static Groups groups = null;
    private static Object writeLock = new Object();
    private Logger logger = Logger.getLogger(this.getClass());
    private String ResourceBundleName = "org.eclipse.cosmos.dc.broker.internal.persistence.brokerMessages";
    private static BrokerDatabaseImpl instance = new BrokerDatabaseImpl();

    public static BrokerDatabaseImpl getInstance() {
        return instance;
    }

    private BrokerDatabaseImpl() {
        this.logger.setResourceBundle(ResourceBundle.getBundle(this.ResourceBundleName));
    }

    @Override
    public void init(Map<String, Object> initMap) {
        String dbdir = initMap.get("dbdir").toString();
        this.setDatabaseDir(dbdir);
    }

    private void setDatabaseDir(String dbdirpath) {
        File dbdir = new File(dbdirpath);
        if (!dbdir.exists()) {
            dbdir.mkdir();
            this.logger.l7dlog((Priority)Level.INFO, "CREATED_DB_INFO", new Object[]{dbdirpath}, null);
        }
        databaseDir = dbdir;
    }

    @Override
    public Groups getAllGroups() throws BrokerDatabaseException {
        if (groups == null) {
            this.loadxml();
        }
        return groups;
    }

    @Override
    public Groups getGroupsByNamespace(String ns) throws BrokerDatabaseException {
        if (groups == null) {
            this.loadxml();
        }
        Groups result = new Groups();
        block0: for (Group group : groups.getGroups()) {
            List<Service> serviceList;
            Services services = group.getServices();
            if (services == null || (serviceList = services.getServices()) == null) continue;
            for (Service service : serviceList) {
                if (!service.getNamespace().equals(ns)) continue;
                result.addGroup(group);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Group getGroup(String hostname, String groupName) throws BrokerDatabaseException {
        if (groups == null) {
            this.loadxml();
        }
        for (Group group : groups.getGroups()) {
            if (!group.getHost().equals(hostname) || !group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addGroup(Group newgroup) throws BrokerDatabaseException {
        boolean dup = false;
        if (groups == null) {
            this.loadxml();
        }
        Object object = writeLock;
        synchronized (object) {
            block6: {
                String host = newgroup.getHost();
                String name = newgroup.getName();
                List<Group> groupList = groups.getGroups();
                for (Group group : groupList) {
                    if (!group.getHost().equals(host) || !group.getName().equals(name)) continue;
                    dup = true;
                    break;
                }
                if (dup) break block6;
                groupList.add(newgroup);
                this.save();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteGroup(String hostname, String groupName) throws BrokerDatabaseException {
        boolean groupDeleted = false;
        if (groups == null) {
            this.loadxml();
        }
        Object object = writeLock;
        synchronized (object) {
            List<Group> groupList = groups.getGroups();
            for (Group group : groupList) {
                if (!group.getHost().equals(hostname) || !group.getName().equals(groupName)) continue;
                groupDeleted = groupList.remove(group);
                break;
            }
            this.save();
        }
        return groupDeleted;
    }

    private void loadxml() throws BrokerDatabaseException {
        if (databaseDir == null) {
            throw new BrokerDatabaseException("Database directory not set");
        }
        if (databaseFile == null && !(databaseFile = new File(databaseDir, "brokerdb.xml")).exists()) {
            try {
                databaseFile.createNewFile();
            }
            catch (IOException e) {
                this.logger.l7dlog((Priority)Level.ERROR, "BROKER_DB_CREATION_ERROR", new Object[]{databaseDir}, (Throwable)e);
                throw new BrokerDatabaseException("Failed to create broker database at " + databaseDir);
            }
            groups = new Groups();
            this.save();
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(databaseFile);
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader(stream);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            OMElement docRoot = builder.getDocumentElement();
            groups = Groups.getGroups(docRoot);
        }
        catch (Exception e) {
            this.logger.l7dlog((Priority)Level.ERROR, "LOAD_BROKER_DB_ERROR", (Throwable)e);
            throw new BrokerDatabaseException("Failed to load broker database.", e);
        }
    }

    private synchronized void save() throws BrokerDatabaseException {
        try {
            FileWriter fw = new FileWriter(databaseFile);
            OMElement om = groups.toOM();
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(fw);
            om.serialize(writer);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            this.logger.l7dlog((Priority)Level.ERROR, "SAVE_BROKER_DB_ERROR", (Throwable)e);
            throw new BrokerDatabaseException("Failed to save broker database xml. ", e);
        }
    }
}

