/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.internal.repository.core.FileSystemSMLRepository;
import org.eclipse.cosmos.rm.internal.repository.operations.IValidationOutputFactory;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.FileOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.common.SystemOutput;
import org.eclipse.cosmos.rm.internal.validation.core.IValidationListener;
import org.eclipse.cosmos.rm.internal.validation.core.IValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ValidationEvent;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.AcyclicValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.IdentityConstraintValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.ReferenceValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.SchemaValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.SchematronValidator;
import org.eclipse.cosmos.rm.internal.validation.smlvalidators.TargetValidator;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.core.SMLRepositoryFactory;
import org.eclipse.cosmos.rm.provisional.repository.exception.MissingRepositoryException;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryConnectionException;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.operations.ISMLOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLMainValidator
implements IValidationListener {
    private static final String OPTION_XML = "-xml";
    private static final String OPTION_SML = "-sml";
    private static final String OPTION_SCHEMATRON = "-schematron";
    private static final String OPTION_FILE = "-output";
    private static final String OPTION_CONTEXT = "-context";
    private static final String OPTION_CONFIGURATION = "-configuration";
    private static final String OPTION_SUPPRESS_WARNINGS = "-sw";
    private static final String SML_IF_SCHEMA = "validation-resources/smlif.xsd";
    private static String contextDirectory;
    private static String configurationFile;
    private static boolean suppressWarnings;
    private static IValidationOutputFactory validationOutputFactory;
    private static IValidationOutputFactory defaultValidationOutputFactory;
    private Map<String, Object> attributes = new Hashtable<String, Object>();
    private IProgressMonitor monitor;

    static {
        defaultValidationOutputFactory = new IValidationOutputFactory(){

            public AbstractValidationOutput createEclipseOutput() {
                return new SystemOutput();
            }
        };
    }

    public SMLMainValidator() {
        this.setDefaultAttributes();
    }

    protected void setDefaultAttributes() {
        this.attributes.put("attribute.environment", "value.environment.standalone");
        this.attributes.put("attribute.validation.xml", "default.validation.xml");
        ArrayList<String> smlValidators = new ArrayList<String>();
        smlValidators.add(AcyclicValidator.class.getName());
        smlValidators.add(IdentityConstraintValidator.class.getName());
        smlValidators.add(TargetValidator.class.getName());
        smlValidators.add(SchemaValidator.class.getName());
        smlValidators.add(SchematronValidator.class.getName());
        smlValidators.add(ReferenceValidator.class.getName());
        this.attributes.put("attribute.validation.sml", smlValidators);
        this.attributes.put("validation.schema.smlif", SML_IF_SCHEMA);
        this.attributes.put("validation.policy.fastfail", "false");
    }

    public void initialize(Map<String, Object> attributes) {
        for (String currentKey : attributes.keySet()) {
            this.setAttribute(currentKey, (String)attributes.get(currentKey));
        }
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    /*
     * Exception decompiling
     */
    public boolean start() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean validate(IValidator[] validators) {
        boolean allValid = true;
        int workPerXValidators = (int)Math.ceil((double)validators.length / 7.0);
        int counter = 0;
        int totalWorkReported = 0;
        int i = 0;
        while (i < validators.length) {
            if (this.monitor.isCanceled()) {
                return allValid;
            }
            ++counter;
            if (validators[i] != null && !validators[i].validate()) {
                allValid = false;
                if (this.fastFailPolicy()) {
                    return false;
                }
            }
            if (counter == workPerXValidators) {
                counter = 0;
                this.monitor.worked(1);
                ++totalWorkReported;
            }
            ++i;
        }
        int remainingWork = 7 - totalWorkReported;
        if (remainingWork > 0) {
            this.monitor.worked(remainingWork);
        }
        return allValid;
    }

    private boolean fastFailPolicy() {
        String fastFail = (String)this.attributes.get("validation.policy.fastfail");
        if (fastFail != null) {
            return Boolean.valueOf(fastFail);
        }
        return false;
    }

    private void initValidators(IValidator[] validators) {
        int i = 0;
        while (i < validators.length) {
            if (validators[i] != null) {
                validators[i].initialize(this.attributes);
                validators[i].addValidationListener((IValidationListener)this);
            }
            ++i;
        }
    }

    protected AbstractValidationOutput createValidationOutput() {
        String environment = (String)this.attributes.get("attribute.environment");
        Object validationOutput = null;
        validationOutput = "value.environment.eclipse".equals(environment) ? this.createEclipseOutput() : ("value.environment.standalone".equals(environment) ? new FileOutput() : new SystemOutput());
        return validationOutput;
    }

    protected AbstractValidationOutput createEclipseOutput() {
        return SMLMainValidator.getEclipseValidationOutputFactory().createEclipseOutput();
    }

    public static IValidationOutputFactory getEclipseValidationOutputFactory() {
        if (validationOutputFactory == null) {
            return defaultValidationOutputFactory;
        }
        return validationOutputFactory;
    }

    public static void setEclipseValidationOutputFactory(IValidationOutputFactory factory) {
        validationOutputFactory = factory;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public static void main(String[] args) {
        if (args.length <= 0) {
            SMLMainValidator.printUsage();
            return;
        }
        int lastInx = -1;
        int currentInx = 0;
        Hashtable<String, Object> validationAttributes = new Hashtable<String, Object>();
        try {
            while (lastInx != currentInx) {
                lastInx = currentInx;
                currentInx = SMLMainValidator.processOption(validationAttributes, args, currentInx);
            }
            if (currentInx != args.length - 1) {
                SMLMainValidator.printUsage();
                return;
            }
            validationAttributes.put("attribute.environment", "value.environment.standalone");
            if (System.getProperty("org.eclipse.cosmos.rm.repository") == null) {
                System.setProperty("org.eclipse.cosmos.rm.repository", FileSystemSMLRepository.class.getName());
            }
            ISMLRepository repository = SMLRepositoryFactory.createRepository();
            Hashtable<String, Object> repositoryAttributes = new Hashtable<String, Object>();
            if (configurationFile != null) {
                repositoryAttributes.put("org.eclipse.cosmos.rm.repository.ATTRIBUTE_CONFIGURATION_PROPERTY", configurationFile);
            } else if (contextDirectory != null) {
                repositoryAttributes.put("root.directory", contextDirectory);
            } else {
                repositoryAttributes.put("root.directory", System.getProperty("user.dir"));
            }
            repository.connect(repositoryAttributes);
            ISMLOperation validationOperation = repository.getOperation("org.eclipse.cosmos.rm.provisional.repository.operations.ISMLValidateOperation");
            StringTokenizer resources = new StringTokenizer(args[currentInx], ",");
            StringBuffer smlModelUnits = new StringBuffer();
            if (suppressWarnings) {
                validationAttributes.put("validation.suppress.warnings", Boolean.TRUE);
            }
            validationAttributes.put("validation.input.type", "value.sml.if");
            while (resources.hasMoreTokens()) {
                String currentResource = resources.nextToken();
                try {
                    int documentType;
                    String fullPath = currentResource;
                    String contextDirectory = repository.getProperty("root.directory", "");
                    if (!currentResource.startsWith(contextDirectory)) {
                        fullPath = String.valueOf(contextDirectory) + (contextDirectory.endsWith("/") || contextDirectory.endsWith("\\") ? "" : "/") + currentResource;
                    }
                    if ((documentType = SMLValidatorUtil.identifyDocumentType((File)new File(fullPath))) == 2) {
                        validationAttributes.put("validation.instance", currentResource);
                        validationOperation.setArguments(new Object[]{validationAttributes});
                        validationOperation.run();
                        continue;
                    }
                    if (documentType == 3) continue;
                    smlModelUnits.append(currentResource).append(",");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            if (smlModelUnits.length() > 0) {
                smlModelUnits.deleteCharAt(smlModelUnits.length() - 1);
                validationAttributes.put("validation.input.type", "value.sml.unit");
                validationAttributes.put("validation.instance", smlModelUnits.toString());
                validationOperation.setArguments(new Object[]{validationAttributes});
                validationOperation.run();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SMLMainValidator.printUsage();
        }
        catch (MissingRepositoryException e) {
            e.printStackTrace();
        }
        catch (RepositoryConnectionException e) {
            e.printStackTrace();
        }
        catch (RepositoryOperationException e) {
            e.printStackTrace();
        }
    }

    private static int processOption(Map<String, Object> attributes, String[] args, int inx) throws IllegalArgumentException {
        if (inx < 0 || inx >= args.length) {
            return inx;
        }
        String currentOption = args[inx];
        boolean xml = false;
        xml = OPTION_XML.equals(currentOption);
        if (xml || OPTION_SCHEMATRON.equals(currentOption)) {
            ++inx;
            inx = SMLMainValidator.addAttribute(attributes, args, inx, xml ? "attribute.validation.xml" : "attribute.validation.schematron");
        } else if (OPTION_SML.equals(currentOption)) {
            ArrayList<String> smlValidators = new ArrayList<String>();
            while (++inx < args.length - 1 && !args[inx].startsWith("-")) {
                StringTokenizer st = new StringTokenizer(args[inx]);
                while (st.hasMoreTokens()) {
                    smlValidators.add(st.nextToken());
                }
            }
            if (smlValidators.isEmpty()) {
                throw new IllegalArgumentException();
            }
            attributes.put("attribute.validation.sml", smlValidators);
        } else if (OPTION_FILE.equals(currentOption)) {
            ++inx;
            inx = SMLMainValidator.addAttribute(attributes, args, inx, "attribute.file.output");
        } else if (OPTION_CONTEXT.equals(currentOption)) {
            contextDirectory = args[++inx];
            ++inx;
        } else if (OPTION_CONFIGURATION.equals(currentOption)) {
            configurationFile = args[++inx];
            ++inx;
        } else if (OPTION_SUPPRESS_WARNINGS.equals(currentOption)) {
            suppressWarnings = true;
            ++inx;
        }
        return inx;
    }

    private static int addAttribute(Map<String, Object> attributes, String[] args, int inx, String attribute) throws IllegalArgumentException {
        if (inx >= args.length || args[inx].startsWith("-")) {
            throw new IllegalArgumentException();
        }
        attributes.put(attribute, args[inx]);
        return inx + 1;
    }

    private static void printUsage() {
        System.err.println(SMLValidationMessages.errorIllegalArguments);
    }

    public void validationErrorOccurred(ValidationEvent event) {
        event.continueOnError = !this.fastFailPolicy();
    }
}

