/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Services;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.dc.provisional.service.finder.client.CosmosServiceFinderClient;
import org.eclipse.cosmos.dc.test.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CosmosCLI {
    public static String DEFAULT_BROKER_EPR = "http://localhost:8080/axis2/services/Broker";
    private String _serviceFinderEPR = null;
    private String _brokerEPR = null;
    private String _serviceNamespace = null;
    private String username = null;
    private String password = null;
    private int soapVersion = 12;

    public static void main(String[] args) throws Exception {
        String brokerEPR = DEFAULT_BROKER_EPR;
        if (args.length != 0) {
            brokerEPR = args[0];
        }
        CosmosCLI clnt = new CosmosCLI(brokerEPR);
        clnt.getInput();
    }

    public CosmosCLI(String epr) {
        this._brokerEPR = new String(epr);
        this._serviceFinderEPR = this._brokerEPR.replaceAll("axis2/services/Broker", "axis2/services/CosmosServiceFinder");
    }

    public void getInput() {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        this.printUsage();
        block5: while (true) {
            try {
                while (true) {
                    System.out.print("COSMOS> ");
                    String line = br.readLine();
                    if (line.trim().equals("")) continue;
                    if (line.equals("exit")) break block5;
                    try {
                        this.handleCommand(line);
                        continue block5;
                    }
                    catch (AxisFault a) {
                        this.logMessage(Messages.getString("CosmosCLI.0"));
                        continue;
                    }
                    catch (Exception e) {
                        this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.1"), e.getMessage()));
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                System.exit(1);
                break;
            }
        }
    }

    private void getAllDataManagers() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        this.processListAllDataManagers(brokerclient);
    }

    private void findDataManagers() throws Exception {
        Iterator<?> iter = this.doFindDataManagers();
        while (iter.hasNext()) {
            DataManager dm = (DataManager)iter.next();
            this.printDataManager(dm);
        }
    }

    private void registerAll() throws Exception {
        Iterator<?> iter = this.doFindDataManagers();
        this.doRegister(iter);
    }

    private void deRegister(String host, String name) throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        brokerclient.deregisterGroup(host, name);
    }

    private void handleCommand(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line);
        if (st.hasMoreTokens()) {
            String command = st.nextToken();
            if (command.equalsIgnoreCase("broker")) {
                this.brokerCommands(st);
            } else if (command.equalsIgnoreCase("finddatamanagers")) {
                this.doFind(st);
            } else if (command.equalsIgnoreCase("graphQuery")) {
                this.runGraphQuery(st, line);
            } else if (command.equalsIgnoreCase("set")) {
                this.setCommands(st);
            } else if (command.equalsIgnoreCase("Show")) {
                this.showOptions();
            } else {
                this.printUsage();
            }
        }
    }

    private void brokerCommands(StringTokenizer st) throws Exception {
        String cmd = null;
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.2"));
            return;
        }
        cmd = st.nextToken();
        if (cmd.equals("getDataManagers")) {
            this.doGetDataManagers(st);
        } else if (cmd.equals("registerAllDataManagers")) {
            this.doRegisterAllDataManagers(st);
        } else if (cmd.equals("register")) {
            this.doRegisterOne(st);
        } else if (cmd.equals("registerServiceGroup")) {
            this.doRegisterServiceGroup(st);
        } else if (cmd.equals("deregister")) {
            this.doDeregister(st);
        } else if (cmd.equals("epr")) {
            this.doEPRCommands(st);
        } else {
            this.logMessage(Messages.getString("CosmosCLI.3"));
        }
    }

    private void setCommands(StringTokenizer st) throws Exception {
        String opt = null;
        String value = null;
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.4"));
            return;
        }
        opt = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.49"));
            return;
        }
        value = st.nextToken();
        if (opt.equalsIgnoreCase("soapversion")) {
            if (value.equalsIgnoreCase("11")) {
                this.soapVersion = 11;
            } else if (value.equalsIgnoreCase("12")) {
                this.soapVersion = 12;
            } else {
                this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.50"), value));
                return;
            }
            this.showOptions();
        } else if (opt.equalsIgnoreCase("username")) {
            this.username = value;
            this.showOptions();
        } else if (opt.equalsIgnoreCase("password")) {
            this.password = value;
            this.showOptions();
        } else {
            this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.51"), opt));
            return;
        }
    }

    private void showOptions() throws Exception {
        this.logMessage(Messages.getString("CosmosCLI.52"));
        this.logMessage(this.optionUsage("CosmosCLI.53", this._brokerEPR) + this.optionUsage("CosmosCLI.54", this._serviceFinderEPR) + this.optionUsage("CosmosCLI.55", this._serviceNamespace) + this.optionUsage("CosmosCLI.56", this.username) + this.optionUsage("CosmosCLI.57", this.password) + this.optionUsage("CosmosCLI.58", String.valueOf(this.soapVersion)));
    }

    private String optionUsage(String mesg, String str) {
        return new String(MessageFormat.format(Messages.getString(mesg), str) + "\n");
    }

    private void doRegisterServiceGroup(StringTokenizer st) throws Exception {
        String name = null;
        String host = null;
        boolean found = false;
        String wsdl = null;
        Group theGroup = null;
        Service ts = null;
        Element theWsdl = null;
        Services srv = new Services();
        List list = srv.getServices();
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.4"));
            return;
        }
        host = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.5"));
            return;
        }
        name = st.nextToken();
        theGroup = new Group();
        theGroup.setName(name);
        theGroup.setHost(host);
        while (st.hasMoreTokens()) {
            found = true;
            wsdl = st.nextToken();
            theWsdl = this.getWSDL(wsdl);
            ts = this.makeNewService(theWsdl);
            list.add(ts);
        }
        if (!found) {
            this.logMessage(Messages.getString("CosmosCLI.6"));
        } else {
            theGroup.setServices(srv);
            BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
            brokerclient.registerGroup(theGroup);
            this.logMessage(Messages.getString("CosmosCLI.7"));
        }
    }

    private void logMessage(String message) {
        System.out.println(message);
    }

    private Service makeNewService(Element wsdl) {
        String namespace = null;
        String endpointReference = null;
        String name = null;
        String description = null;
        Service ret = new Service();
        NodeList serv = wsdl.getElementsByTagName("wsdl:service");
        NodeList desc = wsdl.getElementsByTagName("wsdl:documentation");
        namespace = wsdl.getAttribute("targetNamespace");
        ret.setNamespace(namespace);
        if (serv.getLength() > 0) {
            Element se = (Element)serv.item(0);
            name = se.getAttribute("name");
            ret.setName(name);
            NodeList p = se.getElementsByTagName("wsdl:port");
            if (p.getLength() > 0) {
                Element pe = (Element)p.item(0);
                Node pec = pe.getFirstChild();
                Element pecn = (Element)pec.getNextSibling();
                endpointReference = pecn.getAttribute("location");
                ret.setEndpointReference(endpointReference);
            }
        }
        if (desc.getLength() > 0) {
            Element doce = (Element)desc.item(0);
            description = this.extractText(doce);
            ret.setDescription(description);
        }
        return ret;
    }

    private String extractText(Element e) {
        NodeList children = e.getChildNodes();
        int length = children.getLength();
        for (int n = 0; n < length; ++n) {
            Node next = children.item(n);
            if (next.getNodeType() != 3) continue;
            return next.getNodeValue().trim();
        }
        return null;
    }

    private Element getWSDL(String wsdlurl) throws Exception {
        try {
            URL url = new URL(wsdlurl);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            httpConn.setRequestMethod("GET");
            InputStream input = httpConn.getInputStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            Element elem = doc.getDocumentElement();
            return elem;
        }
        catch (Exception e) {
            this.logMessage(Messages.getString("CosmosCLI.8"));
            return null;
        }
    }

    private void doRegisterOne(StringTokenizer st) throws Exception {
        String d = null;
        String s = null;
        Iterator<?> list = null;
        DataManager dm = null;
        boolean found = false;
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.9"));
            return;
        }
        d = st.nextToken();
        if (st.hasMoreTokens()) {
            s = st.nextToken();
            this._serviceFinderEPR = new String(s);
        }
        list = this.doFindDataManagers();
        while (list.hasNext()) {
            dm = (DataManager)list.next();
            if (!dm.getName().equals(d)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.logMessage(Messages.getString("CosmosCLI.10"));
        } else {
            BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
            Group group = dm.getGroup();
            this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.11"), dm.getName()));
            brokerclient.registerGroup(group);
        }
    }

    private void doEPRCommands(StringTokenizer st) throws Exception {
        String cmd = null;
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.12"));
            return;
        }
        cmd = st.nextToken();
        if (cmd.equals("print")) {
            this.doPrint();
        } else if (cmd.equals("change")) {
            this.doChange(st);
        } else {
            this.logMessage(Messages.getString("CosmosCLI.13"));
        }
    }

    private void doPrint() throws Exception {
        this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.14"), this._brokerEPR));
    }

    private void doChange(StringTokenizer st) throws Exception {
        String sns = null;
        if (st.hasMoreTokens()) {
            sns = st.nextToken();
            this._brokerEPR = new String(sns);
            this.logMessage(Messages.getString("CosmosCLI.15"));
        } else {
            this.logMessage(Messages.getString("CosmosCLI.16"));
        }
    }

    private void doGetDataManagers(StringTokenizer st) throws Exception {
        String sns = null;
        if (st.hasMoreTokens()) {
            sns = st.nextToken();
            this._serviceNamespace = new String(sns);
        }
        this.getAllDataManagers();
    }

    private void doRegisterAllDataManagers(StringTokenizer st) throws Exception {
        String sfe = null;
        if (st.hasMoreTokens()) {
            sfe = st.nextToken();
            this._serviceFinderEPR = new String(sfe);
        }
        this.registerAll();
    }

    private void doDeregister(StringTokenizer st) throws Exception {
        String h = null;
        String n = null;
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.17"));
            return;
        }
        h = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.18"));
            return;
        }
        n = st.nextToken();
        this.deRegister(h, n);
        this.logMessage(Messages.getString("CosmosCLI.19"));
    }

    private String getToken(String lastToken, String line) {
        int index = line.indexOf(lastToken);
        if (line.substring(index - 1, index).startsWith("\"")) {
            index += 2;
        }
        if ((index += lastToken.length()) >= line.length()) {
            return null;
        }
        String result = line.substring(index).trim();
        if (result.startsWith("\"")) {
            int endIndex = result.substring(1).indexOf("\"");
            if (endIndex > 0) {
                result = result.substring(1, endIndex + 1);
            }
        } else {
            int endIndex = result.indexOf(" ");
            if (endIndex > 0) {
                result = result.substring(0, endIndex + 1);
            }
        }
        return result;
    }

    private void runGraphQuery(StringTokenizer st, String line) throws Exception {
        String host = null;
        String mdrName = null;
        String queryFilename = null;
        String queryResultFilename = null;
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.20"));
            return;
        }
        host = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.21"));
            return;
        }
        mdrName = st.nextToken();
        if (!st.hasMoreTokens()) {
            this.logMessage(Messages.getString("CosmosCLI.22"));
            return;
        }
        queryFilename = this.getToken(mdrName, line);
        queryResultFilename = this.getToken(queryFilename, line);
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        DataManager dm = brokerclient.getDataManager(host, mdrName);
        if (dm != null) {
            QueryServiceClient queryServiceClient = dm.getCMDBfQueryClient();
            if (queryServiceClient == null) {
                this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.23"), mdrName));
            } else {
                if (this.username != null) {
                    queryServiceClient.setUsername(this.username);
                }
                if (this.password != null) {
                    queryServiceClient.setPassword(this.password);
                }
                queryServiceClient.setSoapVersion(this.soapVersion);
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(queryFilename));
                Element response = queryServiceClient.graphQuery(doc.getDocumentElement());
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer trans = tf.newTransformer();
                StringWriter sw = new StringWriter();
                trans.transform(new DOMSource(response), new StreamResult(sw));
                this.logMessage(Messages.getString("CosmosCLI.24"));
                this.logMessage(sw.toString());
                if (queryResultFilename != null) {
                    File qFile = new File(queryResultFilename);
                    BufferedWriter output = new BufferedWriter(new FileWriter(qFile));
                    output.write(sw.toString());
                    ((Writer)output).close();
                    this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.25"), qFile.getCanonicalPath()));
                }
            }
        } else {
            this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.26"), mdrName));
        }
    }

    private void doFind(StringTokenizer st) throws Exception {
        String epr = null;
        if (st.hasMoreTokens()) {
            epr = st.nextToken();
            this._serviceFinderEPR = new String(epr);
        }
        this.findDataManagers();
    }

    private void printUsage() {
        this.logMessage(Messages.getString("CosmosCLI.27"));
        this.logMessage(Messages.getString("CosmosCLI.28") + this.setUsage("soapversion", "CosmosCLI.59") + this.setUsage("username", "CosmosCLI.60") + this.setUsage("password", "CosmosCLI.61") + "Show" + "\n" + this.brokerUsage("getDataManagers", "CosmosCLI.29") + this.brokerUsage("registerAllDataManagers", "CosmosCLI.30") + this.brokerUsage("register", "CosmosCLI.31") + this.brokerUsage("registerServiceGroup", "CosmosCLI.32") + this.brokerUsage("deregister", "CosmosCLI.33") + this.brokerUsage("epr change", "CosmosCLI.62") + this.brokerUsage2("epr", "print") + MessageFormat.format(Messages.getString("CosmosCLI.34"), "finddatamanagers") + MessageFormat.format(Messages.getString("CosmosCLI.35"), "graphQuery") + "help" + "\n" + "exit");
        this.logMessage(Messages.getString("CosmosCLI.36"));
        this.logMessage(Messages.getString("CosmosCLI.37"));
        this.logMessage(Messages.getString("CosmosCLI.38"));
    }

    private String setUsage(String token, String m) {
        String cmd = new String("set " + token);
        String ret = null;
        ret = new String(MessageFormat.format(Messages.getString(m), cmd) + "\n");
        return ret;
    }

    private String brokerUsage2(String token, String m) {
        String cmd = new String("broker " + token);
        String ret = new String(cmd + " " + m + "\n");
        return ret;
    }

    private String brokerUsage(String token, String m) {
        String cmd = new String("broker " + token);
        String ret = MessageFormat.format(Messages.getString(m), cmd);
        return ret;
    }

    private Iterator<?> doFindDataManagers() throws Exception {
        CosmosServiceFinderClient client = new CosmosServiceFinderClient(this._serviceFinderEPR);
        OMElement dataManagers = client.getDataManagers();
        Vector<DataManager> v = new Vector<DataManager>();
        Iterator iter = dataManagers.getChildElements();
        while (iter.hasNext()) {
            OMElement groupElem = (OMElement)iter.next();
            Group group = Group.getGroup((OMElement)groupElem);
            DataManager dm = new DataManager(group);
            v.add(dm);
        }
        iter = v.iterator();
        return iter;
    }

    private void doRegister(Iterator<?> iter) throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._brokerEPR);
        while (iter.hasNext()) {
            DataManager dm = (DataManager)iter.next();
            Group group = dm.getGroup();
            this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.39"), dm.getName()));
            brokerclient.registerGroup(group);
        }
        this.logMessage(Messages.getString("CosmosCLI.40"));
    }

    private void processListAllDataManagers(BrokerClient brokerclient) throws Exception {
        this.logMessage(Messages.getString("CosmosCLI.41"));
        List dmlist = null;
        dmlist = this._serviceNamespace == null ? brokerclient.getDataManagers() : brokerclient.getDataManagerByNamespace(this._serviceNamespace);
        for (DataManager dm : dmlist) {
            this.printDataManager(dm);
        }
    }

    private void printDataManager(DataManager dm) {
        int count = 1;
        this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.42"), dm.getName()));
        this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.43"), dm.getHost()));
        this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.44"), dm.getDescription()));
        List serviceList = dm.getServices();
        if (serviceList != null) {
            for (Service service : serviceList) {
                String tmp = new String(String.valueOf(count));
                ++count;
                this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.45"), tmp));
                this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.46"), service.getNamespace()));
                this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.47"), service.getEndpointReference()));
                this.logMessage(MessageFormat.format(Messages.getString("CosmosCLI.48"), service.getDescription()));
                this.logMessage("");
            }
        }
    }

    private String extractHostAndPort(String filePart, String portValue) {
        int ret = 0;
        int ipindex = filePart.indexOf("//");
        String rest = null;
        String ip = null;
        String full = null;
        String port = null;
        if (ipindex >= 0) {
            ip = filePart.substring(ipindex + 2, filePart.length());
            int seperatorIndex = ip.indexOf(":");
            int slashIndex = ip.indexOf("/");
            if (seperatorIndex < 0) {
                return null;
            }
            port = ip.substring(seperatorIndex + 1, slashIndex);
            rest = ip.substring(seperatorIndex + 1 + port.length(), ip.length());
            ip = ip.substring(0, seperatorIndex);
        } else {
            return null;
        }
        full = new String("http://" + ip + ":" + (portValue == null ? port : portValue) + rest);
        ret = Integer.valueOf(port);
        return portValue == null ? port : full;
    }
}

