/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.logging.datamgr.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.dc.internal.logging.datamgr.client.CBESeverityCount;
import org.eclipse.cosmos.dc.internal.logging.datamgr.client.ICBEClient;
import org.eclipse.tptp.logging.events.cbe.CommonBaseEvent;
import org.eclipse.tptp.logging.events.cbe.EventFactory;
import org.eclipse.tptp.logging.events.cbe.Situation;
import org.eclipse.tptp.logging.events.cbe.impl.EventFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBEClient
implements ICBEClient {
    private EndpointReference epr;
    private ServiceClient sender;
    public static final String DM_NAMESPACE = "http://datamgr.logging.internal.dc.cosmos.eclipse.org";

    public CBEClient(String eprstr) throws CosmosException {
        this.epr = new EndpointReference(eprstr);
        this.Init();
    }

    @Override
    public Collection<String> getDatasets() throws CosmosException {
        Collection<String> ret = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getLogFileIdentifiers", omNs);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(tsRequest);
        }
        catch (AxisFault a) {
            throw new CosmosException((Throwable)a);
        }
        Iterator Iter = result.getChildElements();
        ret = this.getFiles(Iter);
        return ret;
    }

    @Override
    public Collection<CommonBaseEvent> getAllCBE(String logfile) throws CosmosException {
        Collection<CommonBaseEvent> ret = null;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getCBEs", omNs);
        OMElement value1 = fac.createOMElement("logfile", omNs);
        value1.addChild((OMNode)fac.createOMText((OMContainer)value1, logfile));
        tsRequest.addChild((OMNode)value1);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(tsRequest);
        }
        catch (AxisFault axisFault) {
            throw new CosmosException("AxisFault");
        }
        Iterator Iter = result.getChildElements();
        ret = this.DoAllCBE(Iter);
        return ret;
    }

    @Override
    public Collection<CBESeverityCount> getCBECountBySeverity(String logfile) throws CosmosException {
        Collection<CommonBaseEvent> cbe = null;
        Iterator<CommonBaseEvent> cbeI = null;
        CommonBaseEvent ev2 = null;
        String cname = null;
        CBESeverityCount sc = null;
        cbe = this.getAllCBE(logfile);
        HashMap<String, CBESeverityCount> componentMap = new HashMap<String, CBESeverityCount>();
        for (CommonBaseEvent ev2 : cbe) {
            cname = ev2.getSourceComponentId().getComponent();
            sc = (CBESeverityCount)componentMap.get(cname);
            if (sc == null) {
                sc = new CBESeverityCount(cname);
                componentMap.put(cname, sc);
            }
            if (ev2.getSeverity() >= 50) {
                sc.setSevereCount(sc.getSevereCount() + 1);
                continue;
            }
            if (ev2.getSeverity() >= 30) {
                sc.setWarningCount(sc.getWarningCount() + 1);
                continue;
            }
            sc.setInfoCount(sc.getInfoCount() + 1);
        }
        return componentMap.values();
    }

    private void Init() throws CosmosException {
        Options options = new Options();
        options.setTo(this.epr);
        options.setTransportInProtocol("http");
        try {
            this.sender = new ServiceClient();
        }
        catch (AxisFault axisFault) {
            throw new CosmosException("AxisFault");
        }
        this.sender.setOptions(options);
    }

    private Collection<String> getFiles(Iterator Iter) {
        ArrayList<String> ret = null;
        ret = new ArrayList<String>();
        this.Populate(Iter, ret);
        return ret;
    }

    private void Populate(Iterator Iter, ArrayList<String> list) {
        while (Iter.hasNext()) {
            Iterator n;
            String t;
            OMElement elem = (OMElement)Iter.next();
            if (elem.getLocalName().equals("LogFile") && (t = elem.getText()) != null && t.length() > 0) {
                list.add(t);
            }
            if ((n = elem.getChildElements()) == null) continue;
            this.Populate(n, list);
        }
    }

    private void Print(Iterator Iter) {
        while (Iter.hasNext()) {
            Iterator n;
            OMElement elem = (OMElement)Iter.next();
            System.out.println("Name " + elem.getLocalName());
            String t = elem.getText();
            if (t != null && t.length() > 0) {
                System.out.println("Text: " + t);
            }
            if ((n = elem.getChildElements()) == null) continue;
            this.Print(n);
        }
    }

    private Collection<CommonBaseEvent> DoAllCBE(Iterator Iter) {
        ArrayList<CommonBaseEvent> ret = null;
        ret = new ArrayList<CommonBaseEvent>();
        this.lookForCBE(Iter, ret);
        return ret;
    }

    private void lookForCBE(Iterator Iter, Collection<CommonBaseEvent> list) {
        while (Iter.hasNext()) {
            Iterator n;
            OMElement elem = (OMElement)Iter.next();
            if (elem.getLocalName().equals("CommonBaseEvent")) {
                this.CreateCBE(Iter, list);
            }
            if ((n = elem.getChildElements()) == null) continue;
            this.lookForCBE(n, list);
        }
    }

    private void CreateCBE(Iterator Iter, Collection<CommonBaseEvent> list) {
        EventFactory eventFactory = EventFactoryImpl.getInstance();
        CommonBaseEvent cbe = eventFactory.createCommonBaseEvent();
        OMElement e = (OMElement)Iter.next();
        this.ProcessBaseAttributes(e, cbe);
        this.ProcessStuff(e, cbe);
        list.add(cbe);
    }

    private void ProcessStuff(OMElement elem, CommonBaseEvent cbe) {
        Iterator n = elem.getChildElements();
        while (n.hasNext()) {
            OMElement e = (OMElement)n.next();
            String l = e.getLocalName();
            if (l.equals("extendedDataElements")) {
                this.ProcessExtendedDataElements(e, cbe);
            }
            if (l.equals("sourceComponentId")) {
                this.ProcessSourceComponentId(e, cbe);
            }
            if (!l.equals("situation")) continue;
            this.ProcessSituation(e, cbe);
        }
    }

    private void ProcessExtendedDataElements(OMElement elem, CommonBaseEvent cbe) {
        Iterator n = elem.getChildElements();
        OMElement e = (OMElement)n.next();
        String value = e.getText();
        String t = null;
        String name = null;
        int ivalue = 0;
        Iterator attrs = elem.getAllAttributes();
        while (attrs.hasNext()) {
            OMAttribute ae = (OMAttribute)attrs.next();
            if (ae.getLocalName().equals("name")) {
                name = ae.getAttributeValue();
            }
            if (!ae.getLocalName().equals("type")) continue;
            t = ae.getAttributeValue();
        }
        if (!(t.equals("string") || t.equals("short") || t.equals("int"))) {
            System.out.println("Unknown type" + t);
        } else if (t.equals("short")) {
            short svalue = Short.valueOf(value);
            cbe.addExtendedDataElementWithShortValue(name, svalue);
        } else if (t.equals("int")) {
            ivalue = Integer.valueOf(value);
            cbe.addExtendedDataElementWithIntValue(name, ivalue);
        } else {
            cbe.addExtendedDataElement(name, value);
        }
    }

    private void ProcessBaseAttributes(OMElement e, CommonBaseEvent cbe) {
        Iterator attrs = e.getAllAttributes();
        while (attrs.hasNext()) {
            OMAttribute ae = (OMAttribute)attrs.next();
            this.SetBase(cbe, ae);
        }
    }

    private void SetBase(CommonBaseEvent c, OMAttribute arg) {
        short sh;
        String s;
        if (arg.getLocalName().equals("creationTime")) {
            c.setCreationTime(arg.getAttributeValue());
        }
        if (arg.getLocalName().equals("globalInstanceId")) {
            c.setGlobalInstanceId(arg.getAttributeValue());
        }
        if (arg.getLocalName().equals("extensionName")) {
            c.setExtensionName(arg.getAttributeValue());
        }
        if (arg.getLocalName().equals("localInstanceId")) {
            c.setLocalInstanceId(arg.getAttributeValue());
        }
        if (arg.getLocalName().equals("msg")) {
            c.setMsg(arg.getAttributeValue());
        }
        if (arg.getLocalName().equals("priority")) {
            s = arg.getAttributeValue();
            sh = Short.valueOf(s);
            c.setPriority(sh);
        }
        if (arg.getLocalName().equals("repeatCount")) {
            s = arg.getAttributeValue();
            sh = Short.valueOf(s);
            c.setRepeatCount(sh);
        }
        if (arg.getLocalName().equals("sequenceNumber")) {
            s = arg.getAttributeValue();
            long l = Long.valueOf(s);
            c.setSequenceNumber(l);
        }
        if (arg.getLocalName().equals("severity")) {
            s = arg.getAttributeValue();
            short sh2 = Short.valueOf(s);
            c.setSeverity(sh2);
        }
    }

    private void ProcessSourceComponentId(OMElement e, CommonBaseEvent cbe) {
        String application = new String("");
        String component = new String("");
        String subComponent = new String("");
        String componentType = new String("");
        String componentIdType = new String("");
        String location = new String("");
        String locationType = new String("");
        Iterator attrs = e.getAllAttributes();
        while (attrs.hasNext()) {
            OMAttribute ae = (OMAttribute)attrs.next();
            if (ae.getLocalName().equals("application")) {
                application = ae.getAttributeValue();
            }
            if (ae.getLocalName().equals("component")) {
                component = ae.getAttributeValue();
            }
            if (ae.getLocalName().equals("subComponent")) {
                subComponent = ae.getAttributeValue();
            }
            if (ae.getLocalName().equals("componentType")) {
                componentType = ae.getAttributeValue();
            }
            if (ae.getLocalName().equals("ComponentIdType")) {
                componentIdType = ae.getAttributeValue();
            }
            if (ae.getLocalName().equals("location")) {
                location = ae.getAttributeValue();
            }
            if (ae.getLocalName().equals("locationType")) {
                locationType = ae.getAttributeValue();
            }
            cbe.setSourceComponentId(application, component, subComponent, componentType, componentIdType, location, locationType);
        }
    }

    private void ProcessSituation(OMElement e, CommonBaseEvent cbe) {
        EventFactory eventFactory = EventFactoryImpl.getInstance();
        Situation s = eventFactory.createSituation();
        Iterator n = e.getChildElements();
        Iterator attrs = e.getAllAttributes();
        while (attrs.hasNext()) {
            OMAttribute ae = (OMAttribute)attrs.next();
            if (ae.getLocalName().equals("categoryName")) {
                // empty if block
            }
            s.setCategoryName(ae.getAttributeValue());
        }
        OMElement el = (OMElement)n.next();
        String type = this.SetArg(el, "type");
        String reason = this.SetArg(el, "reasoningScope");
        String available = this.SetArg(el, "availabilityDisposition");
        String operation = this.SetArg(el, "operationDisposition");
        String process = this.SetArg(el, "processingDisposition");
        String success = this.SetArg(el, "successDisposition");
        String situation = this.SetArg(el, "situationDisposition");
        String depend = this.SetArg(el, "dependencyDisposition");
        String feature = this.SetArg(el, "featureDisposition");
        String any = this.SetArg(el, "any");
        String rcat = this.SetArg(el, "ReportCategory");
        String qualifier = this.SetArg(el, "situationQualifier");
        if (type.equals("AvailableSituation")) {
            s.setAvailableSituation(reason, available, operation, process);
        }
        if (type.equals("ConfigureSituation")) {
            s.setConfigureSituation(reason, success);
        }
        if (type.equals("ConnectSituation")) {
            s.setConnectSituation(reason, situation, success);
        }
        if (type.equals("CreateSituation")) {
            s.setCreateSituation(reason, success);
        }
        if (type.equals("DependencySituation")) {
            s.setDependencySituation(reason, depend);
        }
        if (type.equals("DestroySituation")) {
            s.setDestroySituation(reason, success);
        }
        if (type.equals("FeatureSituation")) {
            s.setFeatureSituation(reason, feature);
        }
        if (type.equals("OtherSituation")) {
            s.setOtherSituation(reason, any);
        }
        if (type.equals("ReportSituation")) {
            s.setReportSituation(reason, rcat);
        }
        if (type.equals("RequestSituation")) {
            s.setRequestSituation(reason, qualifier, success);
        }
        if (type.equals("StartSituation")) {
            s.setStartSituation(reason, qualifier, success);
        }
        if (type.equals("StopSituation")) {
            s.setStopSituation(reason, qualifier, success);
        }
        cbe.setSituation(s);
    }

    public String SetArg(OMElement el, String arg) {
        String ret = null;
        Iterator attrs = el.getAllAttributes();
        while (attrs.hasNext()) {
            OMAttribute ae = (OMAttribute)attrs.next();
            if (!ae.getLocalName().equals(arg)) continue;
            ret = ae.getAttributeValue();
        }
        return ret;
    }
}

