/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.core.IValidationListener;
import org.eclipse.cosmos.rm.internal.validation.core.IValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ValidationEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidator
implements IValidator {
    private IValidationOutput<String, Object> validationOutput;
    private Collection<IValidationListener> validationListeners;
    private IProgressMonitor monitor;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        this.validationOutput = (IValidationOutput)validationAttribute.get("validation.output");
        this.monitor = (IProgressMonitor)validationAttribute.get("validation.progress");
    }

    public IValidationOutput<String, Object> getValidationOutput() {
        return this.validationOutput;
    }

    public void setValidationOutput(IValidationOutput<String, Object> validationOutput) {
        this.validationOutput = validationOutput;
    }

    @Override
    public final void addValidationListener(IValidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<IValidationListener>();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    protected final void fireValidationEventOccurred(ValidationEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners != null) {
            for (IValidationListener listener : this.validationListeners) {
                listener.validationErrorOccurred(event);
            }
        }
    }

    protected void setTaskName(String name) {
        if (this.monitor == null) {
            return;
        }
        this.monitor.setTaskName(name);
    }
}

