/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementModel;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementSchemaModel;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSourceBuilder
extends AbstractDataBuilder<Object> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ElementSourceHandler";
    private Map<String, ElementModel> schemas = new HashMap<String, ElementModel>();
    private boolean documentElementHit;
    private boolean dataElementHit;
    private boolean instanceElementHit = false;
    private boolean definitionElementHit = false;
    private ElementModel currentElementModel;
    private ElementLocation lastDataLocation;
    private List<ElementModel> instances = new ArrayList<ElementModel>();
    private String smlifFile;
    private boolean inEclipse;

    public ElementSourceBuilder(boolean inEclipse, String smlifFile) {
        this.smlifFile = smlifFile;
        this.inEclipse = inEclipse;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (this.dataElementHit) {
            if (!"http://purl.oclc.org/dsdl/schematron".equals(uri) && this.lastDataLocation != null) {
                if ("schema".equals(localName)) {
                    ElementSchemaModel schemaModel = new ElementSchemaModel(qName, this.elementFilePath(), Math.max(this.lastDataLocation.getLineNumber(), 0), this.lastDataLocation.getColumnNumber());
                    schemaModel.setTargetNamespace(attributes.getValue("targetNamespace"));
                    int i = 0;
                    while (i < attributes.getLength()) {
                        if (attributes.getQName(i).startsWith("xmlns") && !attributes.getValue(i).equals(schemaModel.getTargetNamespace())) {
                            schemaModel.addPrerequisiteNamespace(attributes.getValue(i));
                        }
                        ++i;
                    }
                    this.currentElementModel = schemaModel;
                } else {
                    this.currentElementModel = new ElementModel(qName, this.elementFilePath(), Math.max(this.lastDataLocation.getLineNumber(), 0), this.lastDataLocation.getColumnNumber());
                }
                this.lastDataLocation = null;
            }
            boolean importElement = false;
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "import".equals(localName)) {
                importElement = true;
                String namespace = attributes.getValue("namespace");
                if (namespace != null && this.currentElementModel instanceof ElementSchemaModel) {
                    ((ElementSchemaModel)this.currentElementModel).addImportedSchema(namespace);
                }
            }
            boolean needSchemaLocation = importElement && this.currentElementModel != null;
            boolean smlNamespace = false;
            if (importElement) {
                int i = 0;
                while (i < attributes.getLength()) {
                    if ("schemaLocation".equals(attributes.getLocalName(i))) {
                        needSchemaLocation = false;
                    }
                    if ("namespace".equals(attributes.getLocalName(i)) && "http://www.w3.org/2008/03/sml".equals(attributes.getValue(i))) {
                        smlNamespace = true;
                    }
                    ++i;
                }
            }
            if (smlNamespace && needSchemaLocation) {
                StringBuffer buffer = new StringBuffer(" schemaLocation");
                buffer.append("=").append("\"").append("http://www.w3.org/2008/03/sml").append("\"");
                this.currentElementModel.setAdditionalSchemaLocation(buffer.toString());
            }
        }
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("instances".equals(localName)) {
                this.instanceElementHit = true;
            } else if ("definitions".equals(localName)) {
                this.definitionElementHit = true;
            } else if ("document".equals(localName)) {
                this.documentElementHit = true;
            } else if (this.documentElementHit && "data".equals(localName)) {
                this.dataElementHit = true;
                this.lastDataLocation = this.locator != null ? new ElementLocation(null, this.locator.getLineNumber() + 1, this.locator.getColumnNumber() + 1) : new ElementLocation(null, 0, 0);
            }
        }
    }

    private String elementFilePath() {
        return this.smlifFile == null ? this.getFilePath() : this.smlifFile;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if (this.instanceElementHit && "instances".equals(localName)) {
                this.instanceElementHit = false;
            } else if (this.definitionElementHit && "definitions".equals(localName)) {
                this.definitionElementHit = false;
            } else if (this.documentElementHit && "document".equals(localName)) {
                this.documentElementHit = false;
            } else if (this.dataElementHit && "data".equals(localName)) {
                this.dataElementHit = false;
                this.addModelToList();
            }
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "schema".equals(localName)) {
            this.addSchemaToList();
        }
    }

    private void addModelToList() {
        if (this.currentElementModel == null) {
            return;
        }
        this.processCurrentElementModel();
        if (!this.instances.contains(this.currentElementModel)) {
            this.instances.add(this.currentElementModel);
        }
        this.currentElementModel = null;
    }

    private void processCurrentElementModel() {
        if (this.locator != null) {
            this.currentElementModel.setEndingLine(this.locator.getLineNumber());
        }
        this.getElementSource(this.currentElementModel);
    }

    private void addSchemaToList() {
        if (this.currentElementModel == null) {
            return;
        }
        this.processCurrentElementModel();
        this.schemas.put(((ElementSchemaModel)this.currentElementModel).getTargetNamespace(), this.currentElementModel);
        this.currentElementModel = null;
    }

    private void getElementSource(ElementModel elementModel) {
        LineNumberReader in = null;
        try {
            String path = this.inEclipse ? SMLValidatorUtil.retrieveAbsolutePath(elementModel.getFilePath()) : elementModel.getFilePath();
            in = new LineNumberReader(new FileReader(path));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            String currentLine = in.readLine();
            while (in.getLineNumber() < elementModel.getLineNumber()) {
                currentLine = in.readLine();
            }
            StringBuffer contents = new StringBuffer();
            if (this.smlifFile != null) {
                contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            }
            String firstLine = null;
            if (currentLine.indexOf(60) == -1) {
                currentLine = in.readLine();
                firstLine = String.valueOf(currentLine) + "\n";
            } else {
                int prevTagOnLine = currentLine.lastIndexOf(62, elementModel.getColumnNumber());
                firstLine = String.valueOf(currentLine.substring(prevTagOnLine + 1)) + "\n";
            }
            in.setLineNumber(elementModel.getLineNumber());
            contents.append(firstLine);
            boolean endFound = false;
            while (!endFound && currentLine != null) {
                int endTagIndex;
                currentLine = in.readLine();
                if (currentLine == null) break;
                if (elementModel.getAdditionalSchemaLocation() != null && currentLine.matches(".*[^/][\\s]*import.*")) {
                    endTagIndex = currentLine.indexOf(62, currentLine.indexOf("import"));
                    if (endTagIndex == -1) {
                        currentLine = String.valueOf(currentLine) + elementModel.getAdditionalSchemaLocation();
                    } else {
                        if (currentLine.charAt(endTagIndex - 1) == '/') {
                            --endTagIndex;
                        }
                        currentLine = String.valueOf(currentLine.substring(0, endTagIndex)) + elementModel.getAdditionalSchemaLocation() + currentLine.substring(endTagIndex);
                    }
                }
                if (endFound = currentLine.matches(".*/[\\s]*" + elementModel.getElementName() + "[\\s]*>.*")) {
                    endTagIndex = currentLine.indexOf(elementModel.getElementName());
                    int rightBracket = currentLine.indexOf(62, endTagIndex);
                    elementModel.setEndingLine(in.getLineNumber());
                    elementModel.setEndingColumn(rightBracket);
                    contents.append(String.valueOf(currentLine.substring(0, rightBracket + 1)) + "\n");
                    continue;
                }
                contents.append(String.valueOf(currentLine) + "\n");
            }
            elementModel.setSource(contents.toString());
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, ElementModel> getSchemas() {
        return this.schemas;
    }

    public List<ElementModel> getInstances() {
        return this.instances;
    }

    @Override
    public byte getPhase() {
        return 3;
    }

    @Override
    public Object getDataStructure() {
        return null;
    }
}

