/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.provisional.client;

import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerException;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Groups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerClient {
    private EndpointReference epr;
    private ServiceClient sender = null;

    public BrokerClient(String eprstr) {
        this.epr = new EndpointReference(eprstr);
    }

    private void initSender() throws BrokerException {
        if (this.sender != null) {
            return;
        }
        Options options = new Options();
        options.setTo(this.epr);
        options.setTransportInProtocol("http");
        try {
            this.sender = new ServiceClient();
        }
        catch (AxisFault fault) {
            throw new BrokerException(fault.getMessage(), fault);
        }
        this.sender.setOptions(options);
    }

    public boolean registerGroup(Group group) throws BrokerException {
        OMElement result;
        block4: {
            this.initSender();
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
            OMElement registerGroupRequest = fac.createOMElement("registerGroup", omNs);
            registerGroupRequest.addChild((OMNode)group.toOM());
            result = null;
            try {
                result = this.sender.sendReceive(registerGroupRequest);
                if (!result.getText().equals("REGISTRATION_SUCCESSFUL")) break block4;
                return true;
            }
            catch (AxisFault fault) {
                throw new BrokerException(fault.getMessage(), fault);
            }
        }
        if (result.getText().equals("REGISTRATION_DUPLICATED_SERVICE")) {
            return false;
        }
        return false;
    }

    public boolean deregisterGroup(String hostname, String groupName) throws BrokerException {
        OMElement result;
        block4: {
            this.initSender();
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
            OMElement deregisterGroupRequest = fac.createOMElement("deregisterGroup", omNs);
            OMElement hostxml = fac.createOMElement("host", omNs, (OMContainer)deregisterGroupRequest);
            OMElement groupNamexml = fac.createOMElement("name", omNs, (OMContainer)deregisterGroupRequest);
            fac.createOMText((OMContainer)hostxml, hostname);
            fac.createOMText((OMContainer)groupNamexml, groupName);
            result = null;
            try {
                result = this.sender.sendReceive(deregisterGroupRequest);
                if (!result.getText().equals("DEREGISTRATION_SUCCESSFUL")) break block4;
                return true;
            }
            catch (AxisFault fault) {
                throw new BrokerException(fault.getMessage(), fault);
            }
        }
        if (result.getText().equals("DEREGISTRATION_FAILED")) {
            return false;
        }
        return false;
    }

    public List<DataManager> getDataManagers() throws BrokerException {
        this.initSender();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement getAllGroupsRequest = fac.createOMElement("getAllGroups", omNs);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(getAllGroupsRequest);
        }
        catch (AxisFault fault) {
            throw new BrokerException(fault.getMessage(), fault);
        }
        Groups groups = Groups.getGroups(result);
        ArrayList<DataManager> dataManagers = new ArrayList<DataManager>();
        for (Group group : groups.getGroups()) {
            DataManager dm = new DataManager(group);
            dataManagers.add(dm);
        }
        return dataManagers;
    }

    public DataManager getDataManager(String hostname, String groupName) throws BrokerException {
        this.initSender();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement deregisterGroupRequest = fac.createOMElement("getGroup", omNs);
        OMElement hostxml = fac.createOMElement("host", omNs, (OMContainer)deregisterGroupRequest);
        OMElement groupNamexml = fac.createOMElement("name", omNs, (OMContainer)deregisterGroupRequest);
        fac.createOMText((OMContainer)hostxml, hostname);
        fac.createOMText((OMContainer)groupNamexml, groupName);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(deregisterGroupRequest);
        }
        catch (AxisFault fault) {
            throw new BrokerException(fault.getMessage(), fault);
        }
        if (result != null) {
            return new DataManager(Group.getGroup(result));
        }
        return null;
    }

    public List<DataManager> getDataManagerByNamespace(String ns) throws BrokerException {
        this.initSender();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement getDataManagerByNamespaceRequest = fac.createOMElement("getGroupsByNamespace", omNs);
        OMElement hostxml = fac.createOMElement("namespace", omNs, (OMContainer)getDataManagerByNamespaceRequest);
        fac.createOMText((OMContainer)hostxml, ns);
        OMElement result = null;
        try {
            result = this.sender.sendReceive(getDataManagerByNamespaceRequest);
        }
        catch (AxisFault fault) {
            throw new BrokerException(fault.getMessage(), fault);
        }
        Groups groups = Groups.getGroups(result);
        ArrayList<DataManager> dataManagers = new ArrayList<DataManager>();
        for (Group group : groups.getGroups()) {
            DataManager dm = new DataManager(group);
            dataManagers.add(dm);
        }
        return dataManagers;
    }
}

