/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.samples.cmdbf.services.query;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IRelationshipConvertible;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElement;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IGraphElementCollection;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;
import org.eclipse.cosmos.samples.cmdbf.services.query.SchoolXMLHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLRepository {
    public static final String MDR_ID = "org.eclipse.cosmos.samples.cmdbf.XMLRepository";
    private static final String XML_DATA = "data.xml";
    private static final String SCHOOL_NAMESPACE = "http://school";
    public Student[] students;
    public Teacher[] teachers;
    public ClassSession[] classes;

    public XMLRepository() throws ParserConfigurationException, SAXException, IOException {
        SchoolXMLHandler schoolXMLHandler = new SchoolXMLHandler();
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.newSAXParser().parse(XMLRepository.class.getClassLoader().getResourceAsStream(XML_DATA), (DefaultHandler)schoolXMLHandler);
        this.students = schoolXMLHandler.getStudents();
        this.teachers = schoolXMLHandler.getTeachers();
        this.classes = schoolXMLHandler.getSchoolClasses();
    }

    public static class ClassSession
    implements IItemConvertible,
    IRelationshipConvertible,
    IXMLWritable {
        public Student[] students;
        public Teacher teacher;
        public String name;
        public String courseCode;

        public IItem toItem(INodes parent) {
            IItem item = QueryOutputArtifactFactory.getInstance().createItem();
            item.addInstanceId(QueryOutputArtifactFactory.getInstance().createInstanceId(XMLRepository.MDR_ID, this.courseCode));
            item.addRecord(this.createRecord((IGraphElement)item));
            return item;
        }

        public IRelationship toRelationship(IGraphElementCollection parent) {
            IRelationship relationship = QueryOutputArtifactFactory.getInstance().createRelationship();
            relationship.addRecord(this.createRecord((IGraphElement)relationship));
            return relationship;
        }

        private IRecord createRecord(IGraphElement parent) {
            String recordId = "Record for " + this.name;
            IRecord record = QueryOutputArtifactFactory.getInstance().createRecord(parent, recordId);
            record.addNamespace("", XMLRepository.SCHOOL_NAMESPACE);
            record.setValue((IXMLWritable)this);
            return record;
        }

        public void toXML(StringWriter writer, int indentLevel) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<class name=\"" + this.name + "\" courseCode=\"" + this.courseCode + "\">\n");
            buffer.append(" <students>\n");
            int i = 0;
            while (i < this.students.length) {
                buffer.append("  <enrolledStudent idRef=\"" + this.students[i].identity.id + "\"/>\n");
                ++i;
            }
            buffer.append(" </students>\n");
            buffer.append(" <teacher idRef=\"" + this.teacher.identity.id + "\"/>\n");
            buffer.append("</class>");
            writer.write(String.valueOf(SchoolMember.valueWithIndent(indentLevel, buffer.toString())) + "\n\n");
        }
    }

    public static class Identity {
        public String firstName;
        public String lastName;
        public String id;
    }

    public static abstract class SchoolMember
    implements IItemConvertible,
    IXMLWritable {
        public Identity identity = new Identity();

        public IItem toItem(INodes parent) {
            IItem item = QueryOutputArtifactFactory.getInstance().createItem();
            item.addInstanceId(QueryOutputArtifactFactory.getInstance().createInstanceId(XMLRepository.MDR_ID, this.identity.id));
            String recordId = "Record for " + this.identity.firstName + " " + this.identity.lastName;
            IRecord record = QueryOutputArtifactFactory.getInstance().createRecord((IGraphElement)item, recordId);
            record.addNamespace("", XMLRepository.SCHOOL_NAMESPACE);
            record.setValue((IXMLWritable)this);
            item.addRecord(record);
            return item;
        }

        private static String valueWithIndent(int indent, String value) {
            String tempValue = value;
            StringWriter tabsWriter = new StringWriter();
            tabsWriter.append('\n');
            CMDBfServicesUtil.addIndent((StringWriter)tabsWriter, (int)indent);
            tempValue = tempValue.replace("\n", tabsWriter.toString());
            tempValue = String.valueOf(tabsWriter.toString()) + tempValue;
            return tempValue;
        }

        public void toXML(StringWriter writer, int indentLevel) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<" + this.getElementName() + ">\n");
            buffer.append(" <identity firstName=\"" + this.identity.firstName + "\" lastName=\"" + this.identity.lastName + "\" id=\"" + this.identity.id + "\"/>\n");
            buffer.append("</" + this.getElementName() + ">");
            writer.write(String.valueOf(SchoolMember.valueWithIndent(indentLevel, buffer.toString())) + "\n\n");
        }

        protected abstract String getElementName();
    }

    public static class Student
    extends SchoolMember {
        protected String getElementName() {
            return "student";
        }
    }

    public static class Teacher
    extends SchoolMember {
        protected String getElementName() {
            return "teacher";
        }
    }
}

