/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.demo.internal.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DemoConfig {
    private String tomcatDir;
    private String demoDir;
    private String birt;
    private String dojo;
    private String axis2war;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) {
        File demowebappsdir;
        File[] subdirs;
        this.tomcatDir = args[0];
        this.demoDir = args[1];
        this.birt = args[2];
        this.dojo = args[3];
        this.axis2war = args.length > 4 ? args[4] : null;
        boolean correctinputs = true;
        if (!this.validateTomcatDir()) {
            System.out.println("Invalid Tomcat directory");
            correctinputs = false;
        }
        if (!this.validateDemoDir()) {
            System.out.println("Invalid COSMOS demo install directory");
            correctinputs = false;
        }
        if (!this.validateDojoLocation()) {
            System.out.println("Invalid path to DOJO zip file");
            correctinputs = false;
        }
        if (!this.validateBirtLocation()) {
            System.out.println("Invalid path to BIRT zip file.");
            correctinputs = false;
        }
        if (this.axis2war != null && !this.validateAxis2WarLocation()) {
            System.out.println("Invalid path to axis2.war");
            correctinputs = false;
        }
        if (!correctinputs) {
            System.exit(1);
        }
        if (!this.isAxis2Installed()) {
            if (this.axis2war == null) {
                System.out.println("Axis2 is not installed and path to axis2.war is not provided. ");
                System.out.println("Install is aborted.");
                System.exit(1);
            }
            if (!this.unzipAxis2War(this.axis2war, this.tomcatDir + "/webapps")) {
                System.out.println("Failed to install axis2 on tomcat.  Install is aborted.");
            } else {
                System.out.println("Installed axis2 on Apache Tomcat server.");
            }
        }
        if ((subdirs = (demowebappsdir = new File(this.demoDir, "webapps")).listFiles()) != null) {
            File tomcatwebappsdir = new File(this.tomcatDir, "webapps");
            for (int i = 0; i < subdirs.length; ++i) {
                File dir = subdirs[i];
                File dest = new File(tomcatwebappsdir, dir.getName());
                if (dest.exists()) {
                    System.out.println("Web application " + dir.getName() + " is not installed because a web application with the same name already exists.");
                    continue;
                }
                try {
                    this.copy(dir, dest);
                    System.out.println("Installed web application: " + dir.getName());
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Web application" + dir.getName() + " could not be installed.");
                }
            }
            try {
                this.unzip(this.birt, tomcatwebappsdir + "/COSMOSReportViewer");
                System.out.println("Unzipped BIRT to COSMOSReportViewer");
                File webViewerExample = new File(tomcatwebappsdir, "COSMOSReportViewer/birt-runtime-2_3_0/WebViewerExample");
                File movetodir = new File(tomcatwebappsdir, "COSMOSReportViewer");
                this.movedir(webViewerExample, movetodir);
                System.out.println("Copied BIRT web viewer example to COSMOSReportViewer");
            }
            catch (Exception e) {
                System.out.println("Error occurred when unzipping BIRT to COSMOSReportViewer.");
            }
            try {
                this.unzip(this.dojo, tomcatwebappsdir + "/COSMOSUI");
                System.out.println("Unzipped dojo to COSMOSUI.");
            }
            catch (Exception e) {
                System.out.println("Error occurred when unzipping dojo to COSMOSUI.");
            }
        } else {
            System.out.println("webapps directory not found under COSMOS demo install.");
        }
        File demoservicesdir = new File(this.demoDir, "services");
        File[] srvs = demoservicesdir.listFiles();
        if (srvs != null) {
            File tomcatwebappsdir = new File(this.tomcatDir, "webapps/axis2/WEB-INF/services");
            for (int i = 0; i < srvs.length; ++i) {
                File dir = srvs[i];
                File dest = new File(tomcatwebappsdir, dir.getName());
                if (dest.exists()) {
                    System.out.println("Web service " + dir.getName() + " is not installed because a web service with the same name already exists.");
                    continue;
                }
                try {
                    this.copy(dir, dest);
                    System.out.println("Installed web service: " + dir.getName());
                    continue;
                }
                catch (Exception e) {
                    System.out.println("Web service" + dir.getName() + " could not be installed.");
                }
            }
        } else {
            System.out.println("services directory not found under COSMOS demo install.");
        }
        File axislibdir = new File(this.tomcatDir, "webapps/axis2/WEB-INF/lib");
        File uilibdir = new File(this.tomcatDir, "webapps/COSMOSUI/WEB-INF/lib");
        File[] jarfiles = axislibdir.listFiles(new JarFileFilter());
        try {
            for (int i = 0; i < jarfiles.length; ++i) {
                File target = new File(uilibdir, jarfiles[i].getName());
                this.copy(jarfiles[i], target);
            }
            System.out.println("Copied axis jar files to COSMOSUI.");
        }
        catch (Exception e) {
            System.out.println("Problems occurred while copying axis jar files to COSMOSUI.");
        }
        File reportlibdir = new File(this.tomcatDir, "webapps/COSMOSReportViewer/WEB-INF/lib");
        jarfiles = axislibdir.listFiles(new JarFileFilter());
        try {
            for (int i = 0; i < jarfiles.length; ++i) {
                File target = new File(reportlibdir, jarfiles[i].getName());
                this.copy(jarfiles[i], target);
            }
            System.out.println("Copied axis jar files to COSMOSReportViewer.");
        }
        catch (Exception e) {
            System.out.println("Problems occurred while copying axis jar files to COSMOSReportViewer.");
        }
        File clientlibdir = new File(this.demoDir, "cosmos-client/lib");
        jarfiles = axislibdir.listFiles(new JarFileFilter());
        try {
            for (int i = 0; i < jarfiles.length; ++i) {
                File target = new File(clientlibdir, jarfiles[i].getName());
                this.copy(jarfiles[i], target);
            }
            System.out.println("Copied axis jar files to cosmos client.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Problems occurred while copying axis jar files to cosmos client.");
        }
        String file = this.tomcatDir + "/webapps/axis2/WEB-INF/conf/axis2.xml";
        String pattern = "<parameter name=\"hostname\" locked=\"true\">";
        String newline = "    <parameter name=\"hostname\" locked=\"true\">" + this.getLocalHostname() + "</parameter>";
        boolean rc = this.updateLineInFile(file, pattern, newline);
        if (!rc) {
            System.out.println("Failed to update axis2.xml.");
        } else {
            System.out.println("Updated axis2.xml.");
        }
        String log4jpropLoc = this.tomcatDir + "/webapps/axis2/WEB-INF/classes/log4j.properties";
        File log4jprop = new File(log4jpropLoc);
        if (log4jprop.exists()) {
            boolean log4jconfigured = false;
            BufferedReader bufin = null;
            try {
                bufin = new BufferedReader(new InputStreamReader(new FileInputStream(log4jprop)));
                String line = null;
                while ((line = bufin.readLine()) != null) {
                    if (!line.contains("log4j.logger.org.eclipse.cosmos=")) continue;
                    log4jconfigured = true;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (bufin != null) {
                        bufin.close();
                    }
                }
                catch (Exception e) {}
            }
            if (!log4jconfigured) {
                InputStream in = null;
                OutputStream out = null;
                try {
                    int len;
                    in = this.getClass().getClassLoader().getResourceAsStream("log4jappend.txt");
                    out = new FileOutputStream(log4jprop, true);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        if (!(rc = this.updateLineInFile(file = this.tomcatDir + "/webapps/axis2/WEB-INF/services/SMLMDR/META-INF/services.xml", pattern = "<parameter name=\"root.directory\">", newline = "        <parameter name=\"root.directory\">" + this.tomcatDir.replace('\\', '/') + "/webapps/axis2/WEB-INF/services/SMLMDR/sml-repository</parameter>"))) {
            System.out.println("Failed to update services.xml for SML MDR.");
        } else {
            System.out.println("Updated services.xml for SML MDR.");
        }
        file = this.tomcatDir + "/webapps/axis2/WEB-INF/services/StatDataManager/META-INF/services.xml";
        pattern = "<parameter name=\"derby.system.home\">";
        newline = "        <parameter name=\"derby.system.home\">" + this.demoDir.replace('\\', '/') + "/database</parameter>";
        rc = this.updateLineInFile(file, pattern, newline);
        if (!rc) {
            System.out.println("Failed to update services.xml for statistical MDR.");
        } else {
            System.out.println("Updated services.xml for statistical MDR.");
        }
        try {
            InputStream dbinput = this.getClass().getClassLoader().getResourceAsStream("brokerdb.txt");
            File brokerDbDir = new File(this.tomcatDir + "/webapps/axis2/WEB-INF/database");
            if (!brokerDbDir.exists()) {
                brokerDbDir.mkdirs();
            }
            String newbrokerdbLoc = brokerDbDir.getAbsolutePath() + "/brokerdb.xml";
            File newbrokerdb = new File(newbrokerdbLoc);
            this.copyStreamToFile(dbinput, newbrokerdb);
            this.replaceTokenInFile(newbrokerdbLoc, "localhost", this.getLocalHostname());
            System.out.println("Installed broker database to " + newbrokerdbLoc);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Failed to install broker database.");
        }
    }

    private boolean movedir(File from, File to) {
        File[] fromdirs = from.listFiles();
        for (int i = 0; i < fromdirs.length; ++i) {
            File fileordir = fromdirs[i];
            File dest = new File(to, fileordir.getName());
            if (fileordir.isDirectory() && dest.exists()) {
                this.movedir(fileordir, dest);
            }
            fileordir.renameTo(dest);
        }
        return true;
    }

    private boolean validateTomcatDir() {
        File webapps;
        if (this.tomcatDir == null) {
            return false;
        }
        File tomcat = new File(this.tomcatDir);
        return tomcat.exists() && tomcat.isDirectory() && (webapps = new File(this.tomcatDir, "webapps")).exists() && webapps.isDirectory();
    }

    private boolean validateDemoDir() {
        File demoLoc = new File(this.demoDir);
        if (demoLoc.exists() && demoLoc.isDirectory()) {
            File webapps = new File(this.demoDir, "webapps");
            if (!webapps.exists() || !webapps.isDirectory()) {
                return false;
            }
            File servicesdir = new File(this.demoDir, "services");
            return servicesdir.exists() && servicesdir.isDirectory();
        }
        return false;
    }

    private boolean validateAxis2WarLocation() {
        File axis2warFile = new File(this.axis2war);
        return axis2warFile.exists() && axis2warFile.isFile() && axis2warFile.getName().equals("axis2.war");
    }

    private boolean validateDojoLocation() {
        File dojoFile = new File(this.dojo);
        return dojoFile.exists() && dojoFile.isFile() && dojoFile.getName().equals("dojo-release-1.0.2.zip");
    }

    private boolean validateBirtLocation() {
        File birtFile = new File(this.birt);
        return birtFile.exists() && birtFile.isFile() && birtFile.getName().startsWith("birt-runtime-2.3");
    }

    private boolean isAxis2Installed() {
        File axis2dir = new File(this.tomcatDir, "webapps/axis2");
        return axis2dir.exists() && axis2dir.isDirectory();
    }

    private boolean unzipAxis2War(String path, String webappsdirpath) {
        File webappsdir = new File(webappsdirpath);
        if (!webappsdir.exists() || !webappsdir.isDirectory()) {
            return false;
        }
        File axis2dir = new File(webappsdir, "axis2");
        if (!axis2dir.mkdir()) {
            return false;
        }
        try {
            this.unzip(path, axis2dir.getAbsolutePath());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void unzip(String zipfile, String dest) throws Exception {
        ZipFile zf = new ZipFile(zipfile);
        Enumeration<? extends ZipEntry> zipEnum = zf.entries();
        String dir = dest.replace('\\', '/');
        if (dir.charAt(dir.length() - 1) != '/') {
            dir = dir + "/";
        }
        System.out.println("Unzipping " + zipfile + " to " + dest + "...");
        while (zipEnum.hasMoreElements()) {
            int len;
            ZipEntry item = zipEnum.nextElement();
            if (item.isDirectory()) {
                File newdir = new File(dir + item.getName());
                newdir.mkdirs();
                continue;
            }
            String newfile = dir + item.getName();
            File parentDir = new File(newfile).getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            InputStream in = zf.getInputStream(item);
            FileOutputStream out = new FileOutputStream(newfile);
            byte[] buf = new byte[5012];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
        }
        zf.close();
    }

    private void copy(File sourceLocation, File targetLocation) throws Exception {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copy(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[5012];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    private void copyStreamToFile(InputStream in, File target) throws Exception {
        int len;
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[5012];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateLineInFile(String filepath, String pattern, String newline) {
        boolean updated = false;
        File file = new File(filepath);
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        File temp = new File(filepath + ".temp");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), "UTF8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (!updated && line.contains(pattern)) {
                    out.write(newline);
                    updated = true;
                } else {
                    out.write(line);
                }
                out.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
        }
        file.delete();
        temp.renameTo(file);
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceTokenInFile(String filepath, String token, String newvalue) {
        File file = new File(filepath);
        if (!file.exists() || !file.isFile()) {
            return false;
        }
        File temp = new File(filepath + ".temp");
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(temp), "UTF8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.contains(token)) {
                    line = line.replaceAll(token, newvalue);
                    out.write(line);
                } else {
                    out.write(line);
                }
                out.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {}
        }
        file.delete();
        temp.renameTo(file);
        return true;
    }

    private String getLocalHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            DemoConfig.printUsage();
            System.exit(1);
        }
        new DemoConfig().start(args);
    }

    private static void printUsage() {
        System.out.println("Usage: configDemo [tomcatDir] [cosmosDir] [birt] [dojo] [axis2war]");
        System.out.println("  tomcatDir: Apache Tomcat install directory");
        System.out.println("  cosmosDir: COSMOS Demo install directory");
        System.out.println("  birt: path to BIRT Runtime zip file");
        System.out.println("  dojo: parth to dojo zip file");
        System.out.println("  axis2war: (optional) Path to the axis2.war file");
    }

    private class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".jar");
        }
    }
}

