/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.examples.dr.drs.service.outputter;

import java.util.List;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Service;
import org.eclipse.cosmos.examples.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.BrokerNodeDecorator;

public class NodeDecorator
extends BrokerNodeDecorator {
    public String getDisplayName(Object node) {
        DataManager dm;
        if (node instanceof DataManager && (dm = (DataManager)node) != null) {
            String dmName = dm.getName();
            if (dmName.equalsIgnoreCase("examplemdr")) {
                dmName = Messages.getString("NodeDecorator.1");
            } else if (dmName.equalsIgnoreCase("SMLMDR")) {
                dmName = Messages.getString("NodeDecorator.3");
            } else if (dmName.equalsIgnoreCase("CBEServices")) {
                dmName = Messages.getString("NodeDecorator.5");
            } else if (dmName.equalsIgnoreCase("StatisticalDataManager")) {
                dmName = Messages.getString("NodeDecorator.7");
            } else if (dmName.equalsIgnoreCase("TestFederatingCMDB")) {
                dmName = Messages.getString("NodeDecorator.8");
            } else if (dmName.equalsIgnoreCase("aperimdr")) {
                dmName = Messages.getString("NodeDecorator.9");
            }
            return dmName;
        }
        return Messages.getString("NodeDecorator.0");
    }

    public String getNodeClass(Object node) {
        DataManager dm;
        String nodeClass = "mdr";
        if (node instanceof DataManager && (dm = (DataManager)node) != null) {
            List services = dm.getServices();
            int x = 0;
            while (x < services.size()) {
                Service service = (Service)services.get(x);
                if (dm.getName().equalsIgnoreCase("examplemdr")) {
                    nodeClass = "mdrExample";
                    break;
                }
                if (dm.getName().equalsIgnoreCase("SMLMDR")) {
                    nodeClass = "smlRepository";
                    break;
                }
                if (service.getNamespace().equals("http://datamgr.stat.internal.dc.cosmos.eclipse.org")) {
                    nodeClass = "StatDataManager";
                } else {
                    if (service.getNamespace().equals("http://datamgr.logging.internal.dc.cosmos.eclipse.org")) {
                        nodeClass = "CBEDataManager";
                        break;
                    }
                    if (service.getNamespace().equals("http://cmdbf.org/schema/1-0-0/registration")) {
                        nodeClass = "mdrCMDBf";
                        break;
                    }
                    if (service.getNamespace().equals("http://cmdbf.org/schema/1-0-0/query")) {
                        nodeClass = "mdr";
                        break;
                    }
                }
                ++x;
            }
        }
        return nodeClass;
    }
}

