/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.provisional;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.context.ServiceContext;
import org.apache.log4j.Logger;
import org.eclipse.cosmos.dc.broker.internal.persistence.BrokerDatabaseImpl;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Group;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Groups;
import org.eclipse.cosmos.dc.broker.provisional.persistence.BrokerDatabase;
import org.eclipse.cosmos.dc.broker.provisional.persistence.BrokerDatabaseException;
import org.eclipse.cosmos.dc.broker.provisional.persistence.MalformedRequestException;

public class Broker {
    private BrokerDatabase database = null;
    private Logger logger = null;
    private String ResourceBundleName = "org.eclipse.cosmos.dc.broker.internal.persistence.brokerMessages";

    public void init(ServiceContext serviceContext) {
        this.logger = Logger.getLogger(this.getClass());
        this.logger.setResourceBundle(ResourceBundle.getBundle(this.ResourceBundleName));
        this.database = BrokerDatabaseImpl.getInstance();
        File dbdir = serviceContext.getConfigurationContext().getRealPath("database");
        this.logger.debug((Object)("broker database location: " + dbdir.getAbsolutePath()));
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        initMap.put("dbdir", dbdir);
        this.database.init(initMap);
    }

    public OMElement registerGroup(OMElement registerGroupRequest) throws BrokerDatabaseException {
        boolean groupAdded = false;
        OMElement groupElem = registerGroupRequest.getFirstElement();
        groupAdded = this.database.addGroup(Group.getGroup(groupElem));
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "ns");
        OMElement response = fac.createOMElement("registerGroupResponse", omNs);
        if (groupAdded) {
            fac.createOMText((OMContainer)response, "REGISTRATION_SUCCESSFUL");
        } else {
            fac.createOMText((OMContainer)response, "REGISTRATION_DUPLICATED_SERVICE");
        }
        return response;
    }

    public OMElement deregisterGroup(OMElement deregisterRequest) throws BrokerDatabaseException, MalformedRequestException {
        String host = null;
        String groupName = null;
        boolean deleted = false;
        Iterator childIter = deregisterRequest.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (elem.getLocalName().equals("host")) {
                host = elem.getText();
                continue;
            }
            if (!elem.getLocalName().equals("name")) continue;
            groupName = elem.getText();
        }
        if (host == null || groupName == null) {
            throw new MalformedRequestException("Malformed request message for deregisterGroup operation.");
        }
        deleted = this.database.deleteGroup(host, groupName);
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "ns");
        OMElement response = fac.createOMElement("deregisterGroupResponse", omNs);
        if (deleted) {
            fac.createOMText((OMContainer)response, "DEREGISTRATION_SUCCESSFUL");
        } else {
            fac.createOMText((OMContainer)response, "DEREGISTRATION_FAILED");
        }
        return response;
    }

    public OMElement getAllGroups(OMElement getAllGroupsRequest) throws BrokerDatabaseException {
        Groups groups = this.database.getAllGroups();
        return groups.toOM();
    }

    public OMElement getGroup(OMElement getGroupRequest) throws BrokerDatabaseException, MalformedRequestException {
        Group group = new Group();
        String host = null;
        String groupName = null;
        Iterator childIter = getGroupRequest.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (elem.getLocalName().equals("host")) {
                host = elem.getText();
                continue;
            }
            if (!elem.getLocalName().equals("name")) continue;
            groupName = elem.getText();
        }
        if (host == null || groupName == null) {
            throw new MalformedRequestException("Malformed request message for getGroup operation.");
        }
        group = this.database.getGroup(host, groupName);
        return group.toOM();
    }

    public OMElement getGroupsByNamespace(OMElement getGroupsByNamespaceRequest) throws BrokerDatabaseException, MalformedRequestException {
        String ns = null;
        Groups groups = new Groups();
        Iterator childIter = getGroupsByNamespaceRequest.getChildElements();
        while (childIter.hasNext()) {
            OMElement elem = (OMElement)childIter.next();
            if (!elem.getLocalName().equals("namespace")) continue;
            ns = elem.getText();
        }
        if (ns == null) {
            throw new MalformedRequestException("Malformed request message for getGroupsByNamespace operation.");
        }
        groups = this.database.getGroupsByNamespace(ns);
        return groups.toOM();
    }
}

