/*
 * Decompiled with CFR 0.152.
 */
package org.apache.muse.core;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.muse.core.Persistence;
import org.apache.muse.core.Resource;
import org.apache.muse.core.ResourceManager;
import org.apache.muse.util.messages.Messages;
import org.apache.muse.util.messages.MessagesFactory;
import org.apache.muse.util.xml.XmlUtils;
import org.apache.muse.ws.addressing.EndpointReference;
import org.apache.muse.ws.addressing.soap.SoapFault;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractFilePersistence
implements Persistence {
    private static Messages _MESSAGES = MessagesFactory.get(class$org$apache$muse$core$AbstractFilePersistence == null ? (class$org$apache$muse$core$AbstractFilePersistence = AbstractFilePersistence.class$("org.apache.muse.core.AbstractFilePersistence")) : class$org$apache$muse$core$AbstractFilePersistence);
    private Map _fileNumberTablesByType = new HashMap();
    private String _location = null;
    private ResourceManager _manager = null;
    private Map _parameters = null;
    static /* synthetic */ Class class$org$apache$muse$core$AbstractFilePersistence;

    protected void createResourceFile(EndpointReference epr, Resource resource) throws SoapFault {
        String contextPath = resource.getContextPath();
        int nextNumber = this.getNextFileNumber(contextPath);
        String nextFileName = this.getNextFileName(nextNumber);
        File resourceTypeDir = this.getResourceTypeDirectory(contextPath);
        File resourceFile = new File(resourceTypeDir, nextFileName);
        this.createResourceFile(epr, resource, resourceFile);
        Map fileNumbersByEPR = (Map)this.getFileNumberTables().get(contextPath);
        fileNumbersByEPR.put(epr, new Integer(nextNumber));
    }

    protected abstract void createResourceFile(EndpointReference var1, Resource var2, File var3) throws SoapFault;

    protected void destroyResourceFile(EndpointReference epr) throws SoapFault {
        String contextPath = this.getContextPath(epr);
        Map fileNumbersByEPR = (Map)this.getFileNumberTables().get(contextPath);
        Integer fileNumber = (Integer)fileNumbersByEPR.get(epr);
        FileNumberFilter filter = new FileNumberFilter(fileNumber);
        File resourceTypeDir = this.getResourceTypeDirectory(contextPath);
        File[] results = resourceTypeDir.listFiles(filter);
        if (results.length == 0) {
            Object[] filler = new Object[]{"\n\n" + epr};
            throw new SoapFault(_MESSAGES.get("NoFileForEPR", filler));
        }
        results[0].delete();
        fileNumbersByEPR.remove(epr);
    }

    protected String getContextPath(EndpointReference epr) {
        String addressPath = epr.getAddress().getPath();
        int slash = addressPath.lastIndexOf(47);
        return addressPath.substring(slash + 1);
    }

    protected Integer getFileNumber(String fileName) {
        int underscore = fileName.lastIndexOf(45);
        int extension = fileName.lastIndexOf(46);
        String numberString = fileName.substring(underscore + 1, extension);
        return new Integer(numberString);
    }

    protected Map getFileNumberTables() {
        return this._fileNumberTablesByType;
    }

    protected abstract String getFilePrefix();

    public String getInitializationParameter(String name) {
        return (String)this.getInitializationParameters().get(name);
    }

    public Map getInitializationParameters() {
        return this._parameters;
    }

    protected String getNextFileName(int fileNumber) {
        return this.getFilePrefix() + fileNumber + ".xml";
    }

    protected int getNextFileNumber(String contextPath) {
        Map fileNumbersByEPR = (Map)this.getFileNumberTables().get(contextPath);
        if (fileNumbersByEPR.isEmpty()) {
            return 1;
        }
        TreeSet sortedNumbers = new TreeSet(fileNumbersByEPR.values());
        Integer largest = (Integer)sortedNumbers.last();
        return largest + 1;
    }

    protected File getPersistenceDirectory() {
        String path = this.getPersistenceLocation();
        if (path == null) {
            throw new RuntimeException(_MESSAGES.get("NoPersistenceLocation"));
        }
        File workingDir = this.getResourceManager().getEnvironment().getRealDirectory();
        return new File(workingDir, path);
    }

    public String getPersistenceLocation() {
        return this._location;
    }

    public ResourceManager getResourceManager() {
        return this._manager;
    }

    protected File getResourceTypeDirectory(String contextPath) {
        File dir = new File(this.getPersistenceDirectory(), contextPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public void reload() throws SoapFault {
        ResourceManager manager = this.getResourceManager();
        Iterator i = manager.getResourceContextPaths().iterator();
        while (i.hasNext()) {
            String contextPath = (String)i.next();
            if (!manager.isUsingPersistence(contextPath)) continue;
            this.getFileNumberTables().put(contextPath, new HashMap());
            File resourceTypeDir = this.getResourceTypeDirectory(contextPath);
            this.reloadResources(contextPath, resourceTypeDir);
        }
    }

    protected abstract Resource reloadResource(String var1, Element var2) throws SoapFault;

    protected void reloadResources(String contextPath, File resourceTypeDir) throws SoapFault {
        File[] resourceFiles = resourceTypeDir.listFiles(new ResourceFileFilter());
        for (int n = 0; n < resourceFiles.length; ++n) {
            Document xmlDoc = null;
            try {
                xmlDoc = XmlUtils.createDocument(resourceFiles[n]);
            }
            catch (Throwable error) {
                throw new RuntimeException(error.getMessage(), error);
            }
            Element root = XmlUtils.getFirstElement(xmlDoc);
            Resource resource = this.reloadResource(contextPath, root);
            String fileName = resourceFiles[n].getName();
            Integer fileNumber = this.getFileNumber(fileName);
            Map fileNumbersByEPR = (Map)this.getFileNumberTables().get(contextPath);
            fileNumbersByEPR.put(resource.getEndpointReference(), fileNumber);
        }
    }

    public void setInitializationParameters(Map parameters) {
        this._parameters = parameters;
    }

    public void setPersistenceLocation(String location) {
        this._location = location;
    }

    public void setResourceManager(ResourceManager manager) {
        this._manager = manager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResourceFileFilter
    implements FileFilter {
        private ResourceFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().startsWith(AbstractFilePersistence.this.getFilePrefix());
        }
    }

    private class FileNumberFilter
    implements FileFilter {
        private Integer _fileNumber = null;

        public FileNumberFilter(Integer fileNumber) {
            this._fileNumber = fileNumber;
        }

        public boolean accept(File file) {
            return file.getName().indexOf("-" + this._fileNumber + ".xml") >= 0;
        }
    }
}

