/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.requireLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget");

dojo.declare(
   "org.eclipse.cosmos.provisional.dr.ps.components.query.QueryDialog",
	// superclass	
   org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicQuery,
	{
		// summary: This is a query class used to send a XMLHTTPRequset to submit a CMDBf query to a service 
		// description: Before submitting the request to the service a dialog box is prompted to allow the end 
	    //              user to enter the CMDBf query.
	    //lableDialogQuery:String
	    //  The description label of the dialog box
		labelDialogQuery:"",
		//builder:org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog
		//  The dialog widget that prompts the user for the CMDBf query
		builder:null,
	    //title:String
	    //  The title label of the dialog box		
		title:"",
		bindInput: function(data, callbackMethod){
	    //summary: This method will construct a dialog box that will prompt the user for the CMDBf query.  
	    //The epr property stored in the data parameter is passed to the dialog box  
	   		this.builder = new org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog({callback: callbackMethod, labelQuery:this.labelDialogQuery, title:this.title, UIContext:this.UIContext, epr:data.epr});			   	   
			this.builder.show();		
		},
		render: function(/*String*/input){
		//summary: formats the response received from the request before returning to the widget that created this query object
		//input: the response from the request
			this.builder.destroy();
			this.builder = null;
			return input;
		}
	}
); 

 dojo.declare(
	"org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog",
	[dijit._Widget, dijit._Templated, dijit._Container], 
	{
		//row:integer
		//the size of the text area box
	 	rows:12,
	 	//cols:integer
	 	//the size of the text area box
	 	cols:80,
	 	//labelQuery:String
	 	//The description label
		labelQuery:"",
	    //nameLabelQuery:String
	    //  The name label of the dialog box
		nameLabelQuery:"",
		//title:String
		//The title label
		title:"",
		dialogIcon:"",
		name:"",
		item:null,
		_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
		//templaltePath: String
		// url path to the html template that describes the dialog box
		templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/Dialog.html"),
		//widgetsInTemplate:boolean
		// determines if the html template contains dojo widgets
		widgetsInTemplate: true,
		//widgetId: String
		// unique id that identifies this instance.
		widgetId: "queryDialog",
		create: function(params, srcNodeRef) {
		//summary: inherited class from dijit._Widget
			//for some reason I need to destroy widget explicitly
   			if (dijit.byId(this.widgetId) != null)
   				dijit.byId(this.widgetId).destroy();
            var today = new Date();
			this.name=this._message.CMDBFQUERY+" "+today;
			this.item={title:this.name,object:today};
			this.cancelLbl=this._message.CANCEL;
			this.submitLbl=this._message.SUBMIT;
			this.nameLabelQuery=this._message.NAME;
			this.okLbl=this._message.OK;
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog.superclass.create.apply(this, arguments);
		},			
		show: function(){
		//summary: displays the dialog box on the screen
			this.dialogBox.show();
		},
		onCancel: function(){
		//summary: this method is executed when the user clicks on the 'Cancel' button
			this.dialogBox.onCancel();
			this.destroy();
		},
		quit: function(){
		//summary: this method is executed when the user clicks on the 'Quit' button
			this.dialogBox.onCancel();
			this.destroy();
		},
		submitQuery: function(){
		//summary: this method is executed when the user clicks on the 'Submit' button
		//description: The value of the text area is passed into the 'query' parameter used in the request.  Also,
		//             the epr value is passed into the 'epr' parameter used in the request.
			this.item.query = document.getElementById(this.id+"_queryTextArea").value;
			this.item.epr = this.epr;
			this.item.title = document.getElementById(this.id+"_name").value;			
			this.addItem(this.item);				
		},
		destroy:function(){
		//summary: destroys this widget
			if (this.dialogBox){
				this.dialogBox.onCancel();
			}
			this.inherited(arguments);
		},
		addItem: function(item){
		},
		onKeyEvt: function(/*Event*/ evt){
			// summary: keep keyboard focus in dialog; close dialog on escape key
			if(evt.keyCode == dojo.keys.ESCAPE)
			{
				this.destroy(); 
			}
		},		
		postMixInProperties: function(){

			// set the dialog in the dialog box dependent on whether it is register or deregister
            this.dialogIcon="<span class='dialogSubmitQueryWinIcon'></span>";				//call superclass
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog.superclass.postMixInProperties.apply(this, arguments);
		},
		postCreate: function(){
		//summary: inherited class from dijit._Widget
			org.eclipse.cosmos.provisional.dr.ps.components.widget.QueryDialog.superclass.postCreate.apply(this, arguments);
			this.dialogBox = dijit.byId(this.widgetId);
			dojo.connect(this.dialogBox.closeButtonNode,"onclick", this, "destroy");
			dojo.connect(this.dialogBox, "_onKey", this, "onKeyEvt");
		}
		
	}
);
 