/*******************************************************************************
 * Copyright (c) 2007, 2008 CA, Inc. and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA Inc. - initial API and implementation
 *     IBM - Bug fix 220495
 *******************************************************************************/
dojo.provide("org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterResponseDialog");
dojo.require("org.eclipse.cosmos.provisional.dr.ps.components.utility.common");
dojo.require("dijit.Dialog");
dojo.require("dijit.form.Button");
dojo.require("dijit.form.TextBox");
dojo.require("dijit.form.Textarea");
dojo.require("dijit.layout.ContentPane");
dojo.require("dijit.Tree");
dojo.require("dojo.data.ItemFileWriteStore");


dojo.declare(
		"org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterResponseDialog",
		[dijit._Widget, dijit._Templated, dijit._Container, org.eclipse.cosmos.provisional.dr.ps.components.utility.BasicUtility], 
		{
		 	rows:12,
		 	cols:80,
			_message: dojo.i18n.getLocalization("nls.org.eclipse.cosmos.provisional.dr.ps.components", "widget"),
			templatePath:dojo.moduleUrl("org.eclipse.cosmos.provisional.dr.ps.components.widget", "html/RegisterResponseDialog.html"),
			widgetsInTemplate: true,
			widgetId: "registerResponseDialog",		
			iconDialog: "",
			storeURL: null,
			jsonData: null,
			rootLabel: null,					
			
			show: function()
			{
				this.dialogBox.show();			
			},
			
			
			destroy: function()
			{
				this.destroyWidgets(
						["registerResponseDialog", "reglabel", 
						 "registerResponseTree", "closeButton"]);
				if (this.dialogBox)
				{
					this.dialogBox.onCancel();
				}
				this.inherited(arguments);
			},
			
			getResponseTree: function()
			{
				return dijit.byId("registerResponseTree");
			},
			
			onClose: function()
			{
				this.destroy();
			},
							
			postMixInProperties: function()
			{
				// set the dialog in the dialog box dependent on whether it is register or deregister
				// this should go in a jprop file, but as yet its unknown where (Martin).
				this.dialogIcon = "<span class='dialogRegisterResponseWinIcon'></span>";

				//call superclass
				org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterResponseDialog.superclass.postMixInProperties.apply(this, arguments);
			},
			
			create: function()
			{				
				//for some reason I need to destroy widget explicitly
	   			this.destroy();
				
				org.eclipse.cosmos.provisional.dr.ps.components.widget.RegisterResponseDialog.superclass.create.apply(this, arguments);
				
				// Create the store for the response tree
				var treeStore = this.storeURL == null || this.storeURL.length <= 0 ? 
						new dojo.data.ItemFileReadStore ({data: this.jsonData}) :
						new dojo.data.ItemFileReadStore ({url: this.storeURL});
													
						
				// Create the tree
				var element = document.getElementById("registerResponseTree");
		        var responseTree = new dijit.Tree(
		    	    	   { 
		    	    		   store: treeStore,
		    	    		   labelAttr: "label",
		    	    		   childrenAttr: ["response"],
		    	    		   query: {type:"response"},
		    	    		   label: this.rootLabel,
		    	    		   widgetId: "registerResponseTree"
		    	    	   }, 
		    	    	   element);	
		        				
				this.dialogBox = dijit.byId(this.widgetId);
												
				// The caption on the top of the dialog will depend on the result				
				var fontElement = document.createElement("font");				
				
				var _self = this;
				dijit.byId("registerResponseTree").getItemChildren(null, function(items)
				{
					var declined = false;
					for (var i = 0; i < items.length; i++)
					{
						if (items[i].id[0] == "declinedItems")
						{							
							fontElement.setAttribute("color", "red");											
							fontElement.textContent = _self._message.REGISTER_DECLINED;							
							declined = true;
							break;
						}
					}
					
					if (!declined)
					{					
						fontElement.setAttribute("color", "green");
						fontElement.textContent = _self._message.REGISTER_PASSED;
					}
					
					
					fontElement.setAttribute("style", "font-weight: bold");
					var reglabel = document.getElementById("reglabel");
					reglabel.appendChild(fontElement);
					var reglabelDetails = document.getElementById("reglabelDetails");
					reglabelDetails.textContent = _self._message.REGISTER_RESPONSE_COMMON;	
				});	
			}
		}
	);      