/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.Schematron;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleBindings {
    private static final String UNTARGETED = "untargeted";
    protected Map<String, Map<String, List<Schematron>>> data = new HashMap<String, Map<String, List<Schematron>>>();
    private List<Schematron> globallyBoundRules = new ArrayList<Schematron>();

    public void bindRule(String alias, Schematron schematronRule) {
        this.bindRule(UNTARGETED, alias, schematronRule);
    }

    public void bindRule(String uri, String localName, Schematron schematronRule) {
        List<Schematron> rules;
        Map<String, List<Schematron>> schematronRuleMappings = null;
        schematronRuleMappings = this.data.get(uri);
        if (schematronRuleMappings == null) {
            schematronRuleMappings = new HashMap<String, List<Schematron>>();
            this.data.put(uri, schematronRuleMappings);
        }
        if ((rules = schematronRuleMappings.get(localName)) == null) {
            rules = new ArrayList<Schematron>();
            schematronRuleMappings.put(localName, rules);
        }
        rules.add(schematronRule);
    }

    public void addGloballyBoundRule(Schematron schematronRule) {
        this.globallyBoundRules.add(schematronRule);
    }

    public List<Schematron> getBoundRules(String alias) {
        return this.getBoundRules(UNTARGETED, alias);
    }

    public List<Schematron> getBoundRules(String uri, String localName) {
        Map<String, List<Schematron>> schematronRules = this.data.get(uri);
        if (schematronRules == null) {
            return null;
        }
        return schematronRules.get(localName);
    }

    public List<Schematron> getGloballyBoundRules() {
        return this.globallyBoundRules;
    }

    public boolean isRuleBindingPresent() {
        return this.data.size() > 0;
    }
}

