/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.common;

import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeIterator
implements Iterator<Node> {
    private NodeList children;
    private int index;
    private Node next;
    private String uri;
    private String localName;

    public NodeIterator(Node parent, String uri, String localName) {
        this.children = parent.getChildNodes();
        this.index = 0;
        this.uri = uri;
        this.localName = localName;
    }

    @Override
    public boolean hasNext() {
        if (this.index == 0 && this.next == null) {
            this.findNextItem();
        }
        return this.next != null;
    }

    private void findNextItem() {
        int childrenCount = this.children.getLength();
        while (this.index < childrenCount) {
            Node currentNode = this.children.item(this.index);
            if ((this.uri == null || this.uri.equals(currentNode.getNamespaceURI())) && this.localName.equals(currentNode.getLocalName())) {
                this.next = currentNode;
                ++this.index;
                return;
            }
            ++this.index;
        }
        this.next = null;
    }

    @Override
    public Node next() {
        if (this.index == 0 && this.next == null) {
            this.findNextItem();
        }
        Node tmp = this.next;
        this.findNextItem();
        return tmp;
    }

    @Override
    public void remove() {
    }
}

