/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLIFIdentity;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.core.IFoundationBuilder;
import org.eclipse.cosmos.rm.internal.validation.core.IValidationListener;
import org.eclipse.cosmos.rm.internal.validation.core.IValidator;
import org.eclipse.cosmos.rm.internal.validation.core.IXMLValidator;
import org.eclipse.cosmos.rm.internal.validation.core.ValidationFactory;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoundationBuilder
extends DefaultHandler
implements IFoundationBuilder {
    private SAXParser saxParser;
    private IDataBuilder<?>[] dataStructureBuilders;
    private AbstractValidationOutput validationLogger;
    private IXMLValidator xmlValidation;
    private boolean validateXML;
    private byte phase = (byte)2;
    private Locator locator;
    private boolean documentElementHit;
    private boolean smlIfInput;
    private boolean status = true;
    private Collection<IValidationListener> validationListeners;
    private boolean inEclipse;
    private Map<String, Object> attributes;
    private Map<String, String> processedImports = new Hashtable<String, String>();
    private Map<String, String> pendingProcess = new Hashtable<String, String>();
    private String currentResource;
    private StringBuffer remoteURI;

    @Override
    public void initialize(Map<String, Object> validationAttribute) {
        this.validationLogger = (AbstractValidationOutput)validationAttribute.get("validation.output");
        this.smlIfInput = !(validationAttribute.get("validation.input.type") instanceof String) || !"value.sml.unit".equals(validationAttribute.get("validation.input.type"));
        this.inEclipse = "value.environment.eclipse".equals(validationAttribute.get("attribute.environment"));
        this.attributes = validationAttribute;
        Object validationClass = validationAttribute.get("attribute.validation.xml");
        this.validateXML = true;
        if (validationClass == null) {
            this.validateXML = false;
        } else if ("default.validation.xml".equals(validationClass)) {
            this.xmlValidation = null;
        } else {
            try {
                IValidator[] validation = ValidationFactory.createValidator(IXMLValidator.class, validationClass);
                this.xmlValidation = validation.length > 0 ? (IXMLValidator)validation[0] : null;
                this.xmlValidation.initialize(validationAttribute);
            }
            catch (InstantiationException instantiationException) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorInstantiating, (Object)validationClass)));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorInstantiating, (Object)validationClass)));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, NLS.bind((String)SMLValidationMessages.errorClassNotFound, (Object)validationClass)));
            }
        }
        this.createSAXParser(this.smlIfInput ? (String)validationAttribute.get("validation.schema.smlif") : null);
    }

    protected void createSAXParser(String xsd) {
        try {
            if (xsd == null) {
                this.validateXML = false;
            }
            InputStream schemaAsStream = xsd == null ? null : this.getClass().getClassLoader().getResourceAsStream(xsd);
            this.saxParser = SMLValidatorUtil.createSAXParser(schemaAsStream, this.validateXML, this, this.validationLogger);
        }
        catch (ParserConfigurationException e) {
            this.fatalError(e);
        }
        catch (SAXNotRecognizedException e) {
            this.fatalError(-1, NLS.bind((String)SMLValidationMessages.errorUnsupportedSAXProperty1, (Object)e.getLocalizedMessage()));
        }
        catch (SAXNotSupportedException e) {
            this.fatalError(-1, NLS.bind((String)SMLValidationMessages.errorUnsupportedSAXProperty1, (Object)e.getLocalizedMessage()));
        }
        catch (SAXException e) {
            this.fatalError(e);
        }
    }

    @Override
    public void error(SAXParseException exception) {
        this.status = false;
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(exception.getLineNumber(), String.valueOf(exception.getLocalizedMessage()) + SMLValidationMessages.commonLine + exception.getLineNumber() + SMLValidationMessages.commonColumn + exception.getColumnNumber()));
    }

    protected void fatalError(Exception exception) {
        this.fatalError(-1, exception.getLocalizedMessage());
    }

    protected void fatalError(int lineNumber, String message) {
        this.status = false;
        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(lineNumber, message));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validate() {
        IProgressMonitor monitor = (IProgressMonitor)this.attributes.get("validation.progress");
        if (monitor != null) {
            monitor.setTaskName(SMLValidationMessages.validationBuildingStructures);
        }
        Throwable exception = null;
        String currentDocument = null;
        int lineNumber = -1;
        try {
            this.retrieveBuilders();
            int i = 0;
            while (i < this.dataStructureBuilders.length) {
                IDataBuilder<Object> dataBuilder = this.dataStructureBuilders[i];
                dataBuilder.setMessageOutputter(this.validationLogger);
                ++i;
            }
            String input = (String)this.attributes.get("validation.instance");
            if (this.smlIfInput) {
                currentDocument = input;
                this.saxParser.parse(new InputSource(new FileInputStream(new File(currentDocument))), (DefaultHandler)this);
                return true;
            }
            StringTokenizer inputs = new StringTokenizer(input, ",");
            ArrayList<ResourceWrapper> instanceList = new ArrayList<ResourceWrapper>();
            SMLIFIdentity identity = (SMLIFIdentity)SMLValidatorUtil.retrieveDataStructure("org.eclipse.cosmos.rm.validation.IdentityDataBuilder");
            SMLIFIdentity metaIdentity = (SMLIFIdentity)this.attributes.get("validation.identity");
            if (identity != null) {
                if (metaIdentity != null) {
                    identity.copy(metaIdentity);
                } else {
                    identity.setBaseURI("");
                }
            }
            this.phase = (byte)2;
            Map ruleBindings = (Map)this.attributes.get("validation.rule.bindings");
            if (ruleBindings != null && ruleBindings.size() > 0) {
                this.elementNotification("http://www.w3.org/2008/03/sml-if", "ruleBindings", "ruleBindings", IValidationConstants.EMPTY_ATTRIBUTES, false, false, true);
                for (String alias : ruleBindings.keySet()) {
                    List rules = (List)ruleBindings.get(alias);
                    if (rules == null) continue;
                    int i2 = 0;
                    int ruleCount = rules.size();
                    while (i2 < ruleCount) {
                        this.ruleNotification(alias, (String)rules.get(i2));
                        ++i2;
                    }
                }
                this.elementNotification("http://www.w3.org/2008/03/sml-if", "ruleBindings", "ruleBindings", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
            }
            this.phase = 1;
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "definitions", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, true, false, true);
            String contextRoot = (String)this.attributes.get("validation.repository.root");
            contextRoot = contextRoot == null ? "" : contextRoot;
            while (inputs.hasMoreTokens()) {
                currentDocument = inputs.nextToken();
                ResourceWrapper resource = this.retrieveResource(currentDocument);
                if (resource == null) {
                    return false;
                }
                String parentFolder = this.findParentFolder(contextRoot, resource.getFullPath());
                this.traverseRecursively(instanceList, resource, true, parentFolder);
                Map processPending = (Map)((Hashtable)this.pendingProcess).clone();
                if (processPending == null) continue;
                for (String namespace : processPending.keySet()) {
                    String path = (String)processPending.get(namespace);
                    if (path == null || this.processedImports.get(namespace) != null) continue;
                    try {
                        this.traverseRecursively(instanceList, new ResourceWrapper(path, this.inEclipse), true, parentFolder);
                    }
                    catch (MissingResourceException missingResourceException) {
                        this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, NLS.bind((String)SMLValidationMessages.warningMissingResource, (Object)path)));
                    }
                }
                this.processedImports.putAll(processPending);
                for (String namespace : processPending.keySet()) {
                    this.processedImports.put(namespace, this.pendingProcess.get(namespace));
                    this.pendingProcess.remove(namespace);
                }
            }
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "definitions", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, true, false, false);
            this.phase = (byte)16;
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "instances", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, false, true, true);
            int i3 = 0;
            int instanceCount = instanceList.size();
            while (i3 < instanceCount) {
                ResourceWrapper currentInstanceResource = (ResourceWrapper)instanceList.get(i3);
                this.traverseRecursively(instanceList, currentInstanceResource, false, this.findParentFolder(contextRoot, currentInstanceResource.getFullPath()));
                ++i3;
            }
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "instances", "definitions", IValidationConstants.EMPTY_ATTRIBUTES, false, true, false);
            return true;
        }
        catch (IOException e) {
            exception = e;
        }
        catch (SAXParseException e) {
            lineNumber = e.getLineNumber();
            exception = e;
        }
        catch (SAXException e) {
            exception = e;
        }
        catch (CoreException e) {
            exception = e;
        }
        catch (ParserConfigurationException e) {
            exception = e;
        }
        if (exception == null) return false;
        this.fatalError(lineNumber, exception.getLocalizedMessage());
        return false;
    }

    private void ruleNotification(String alias, String ruleAlias) throws SAXException {
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"ruleBinding", "documentAlias"}, true);
        this.characters(alias.toCharArray(), 0, alias.length());
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "documentAlias", "documentAlias", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "ruleAlias", "documentAlias", IValidationConstants.EMPTY_ATTRIBUTES, false, false, true);
        this.characters(ruleAlias.toCharArray(), 0, ruleAlias.length());
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"ruleAlias", "ruleBinding"}, false);
    }

    private String findParentFolder(String root, String resource) {
        root = root.replace('\\', '/');
        resource = resource.replace('\\', '/');
        Path rootPath = new Path(root);
        Path resourcePath = new Path(resource);
        if (this.inEclipse) {
            IPath workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            rootPath = rootPath.removeFirstSegments(workspace.segmentCount());
        }
        int i = 0;
        int segCount = rootPath.segmentCount();
        while (i < segCount) {
            if (!resourcePath.segment(0).equals(rootPath.segment(i))) break;
            resourcePath = resourcePath.removeFirstSegments(1);
            ++i;
        }
        String parentFolder = resourcePath.removeLastSegments(1).toString();
        String device = resourcePath.getDevice();
        if (device != null && parentFolder.startsWith(device)) {
            parentFolder = parentFolder.substring(device.length());
        }
        return parentFolder;
    }

    private void traverseRecursively(List<ResourceWrapper> instanceList, ResourceWrapper resource, boolean isDefinition, String parentFolder) throws CoreException, IOException, SAXException, ParserConfigurationException {
        if (resource.isDirectory()) {
            ResourceWrapper[] children = resource.getChildren();
            parentFolder = String.valueOf(parentFolder.length() > 0 ? String.valueOf(parentFolder) + "/" : "") + resource.getName();
            int i = 0;
            while (i < children.length) {
                this.traverseRecursively(instanceList, children[i], isDefinition, parentFolder);
                ++i;
            }
        } else if (resource.isFile()) {
            int type = SMLValidatorUtil.identifyDocumentType(resource);
            this.currentResource = resource.getAbsolutePath();
            switch (type) {
                case 0: {
                    this.addDocument(parentFolder, resource);
                    break;
                }
                case 1: {
                    if (isDefinition) {
                        instanceList.add(resource);
                        return;
                    }
                    this.addDocument(parentFolder, resource);
                    break;
                }
            }
        }
    }

    private void addDocument(String parentFolder, ResourceWrapper resource) throws SAXException, ParserConfigurationException, IOException, CoreException {
        this.addAliases(parentFolder, resource);
        this.processData(resource);
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "document", "document", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
    }

    private void addAliases(String parentFolder, ResourceWrapper resource) throws SAXException {
        List aliases;
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"document", "docinfo", "aliases"}, true);
        Map fileAliasMap = (Map)this.attributes.get("validation.aliases");
        boolean definedAliases = false;
        if (fileAliasMap != null && (aliases = (List)fileAliasMap.get(resource.getName())) != null) {
            definedAliases = aliases.size() > 0;
            int i = 0;
            int aliasCount = aliases.size();
            while (i < aliasCount) {
                String alias = (String)aliases.get(i);
                this.notifyAlias(alias);
                ++i;
            }
        }
        if (!definedAliases) {
            this.notifyAlias(String.valueOf(parentFolder.length() > 0 ? String.valueOf(parentFolder) + "/" : "") + resource.getName());
        }
        this.fireNotifications("http://www.w3.org/2008/03/sml-if", new String[]{"aliases", "docinfo"}, false);
    }

    private void notifyAlias(String alias) throws SAXException {
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "alias", "alias", IValidationConstants.EMPTY_ATTRIBUTES, false, false, true);
        this.characters(alias.toCharArray(), 0, alias.length());
        this.elementNotification("http://www.w3.org/2008/03/sml-if", "alias", "alias", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
    }

    private void processData(ResourceWrapper resource) throws SAXException, ParserConfigurationException, IOException, CoreException {
        InputStream fileInputStream = resource.getContents();
        try {
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "data", "data", IValidationConstants.EMPTY_ATTRIBUTES, false, false, true);
            this.validationLogger.setAssociatedResource(resource);
            int i = 0;
            while (i < this.dataStructureBuilders.length) {
                IDataBuilder<?> dataBuilder = this.dataStructureBuilders[i];
                dataBuilder.setFilePath(resource.getFullPath());
                ++i;
            }
            this.saxParser.parse(fileInputStream, (DefaultHandler)this);
            this.elementNotification("http://www.w3.org/2008/03/sml-if", "data", "data", IValidationConstants.EMPTY_ATTRIBUTES, false, false, false);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    private void fireNotifications(String uri, String[] elements, boolean open) throws SAXException {
        int i = 0;
        while (i < elements.length) {
            this.elementNotification(uri, elements[i], elements[i], IValidationConstants.EMPTY_ATTRIBUTES, false, false, open);
            ++i;
        }
    }

    private ResourceWrapper retrieveResource(String path) {
        try {
            return new ResourceWrapper(path, this.inEclipse);
        }
        catch (MissingResourceException mre) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, mre.getMessage()));
            return null;
        }
    }

    private void retrieveBuilders() {
        if (this.dataStructureBuilders == null) {
            Collection<IDataBuilder<?>> dataBuilders = DataBuilderRegistry.instance().getDataStructureBuilders();
            this.dataStructureBuilders = new IDataBuilder[dataBuilders.size()];
            dataBuilders.toArray(this.dataStructureBuilders);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean startDefinitionsPhase = false;
        boolean startInstancesPhase = false;
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if (this.phase != 16) {
                if (this.phase != 1 && "definitions".equals(localName)) {
                    this.phase = 1;
                    startDefinitionsPhase = true;
                } else if ("instances".equals(localName)) {
                    this.phase = (byte)16;
                    startInstancesPhase = true;
                }
            }
            if (this.phase == 1 || this.phase == 16) {
                if ("document".equals(localName)) {
                    this.documentElementHit = true;
                } else if (this.documentElementHit && "locator".equals(localName)) {
                    this.phase = (byte)4;
                }
            }
            if (this.phase == 4 && "documentURI".equals(localName)) {
                this.remoteURI = new StringBuffer();
                this.phase = (byte)5;
            }
        } else if ("http://www.w3.org/2001/XMLSchema".equals(uri) && "import".equals(localName)) {
            String namespace = attributes.getValue("namespace");
            String location = attributes.getValue("schemaLocation");
            if (namespace != null && location != null && this.currentResource != null && this.processedImports.get(namespace) == null && location.indexOf("//") < 0) {
                int inx = Math.max(this.currentResource.lastIndexOf(47), this.currentResource.lastIndexOf(92));
                String parentFolder = inx >= 0 ? this.currentResource.substring(0, inx) : this.currentResource;
                location = location.startsWith(parentFolder) ? location : String.valueOf(parentFolder) + "/" + location;
                this.pendingProcess.put(namespace, location);
            }
        }
        this.elementNotification(uri, localName, qName, attributes, startDefinitionsPhase, startInstancesPhase, true);
    }

    private void retrieveRemoteDocument(String href) throws SAXException {
        Node node = null;
        SMLValidatorUtil.RemoteRetrievalException exception = null;
        try {
            node = SMLValidatorUtil.retrieveRemoteDocument(href);
            Element dataNode = node.getOwnerDocument().createElementNS("http://www.w3.org/2008/03/sml-if", "data");
            dataNode.appendChild(node);
            node = dataNode;
        }
        catch (SMLValidatorUtil.RemoteRetrievalException e) {
            exception = e;
        }
        if (exception != null || node == null) {
            this.validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(this.locator.getLineNumber(), NLS.bind((String)SMLValidationMessages.errorMissingDocument, (Object)String.valueOf(this.locator.getLineNumber()))));
            return;
        }
        this.walkDocument(node);
    }

    private void walkDocument(Node node) {
        Attributes atts = this.toAttributes(node.getAttributes());
        try {
            this.domNotification(node, atts, true);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            this.walkDocument(children.item(i));
            ++i;
        }
        try {
            this.domNotification(node, atts, false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private void domNotification(Node node, Attributes atts, boolean start) throws SAXException {
        switch (node.getNodeType()) {
            case 1: {
                this.elementNotification(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), atts, false, false, start);
                break;
            }
            case 3: 
            case 8: {
                String value;
                if (!start || (value = node.getNodeValue()) == null) break;
                this.characters(value.toCharArray(), 0, value.length());
                break;
            }
        }
    }

    private Attributes toAttributes(NamedNodeMap attributes) {
        AttributeWrapper attributeWrapper = new AttributeWrapper(attributes);
        return attributeWrapper;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean endDefinitionsPhase = false;
        boolean endInstancesPhase = false;
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if (this.phase == 1 && "definitions".equals(localName)) {
                this.phase = 0;
                endDefinitionsPhase = true;
            } else if (this.phase == 16 && "instances".equals(localName)) {
                this.phase = 0;
                endInstancesPhase = true;
            }
            if ((this.phase == 1 || this.phase == 16) && "document".equals(localName)) {
                this.documentElementHit = false;
            }
            if (this.phase == 5) {
                this.phase = (byte)4;
                this.retrieveRemoteDocument(this.remoteURI.toString());
            }
        }
        this.elementNotification(uri, localName, qName, null, endDefinitionsPhase, endInstancesPhase, false);
    }

    private void elementNotification(String uri, String localName, String qName, Attributes attributes, boolean definitionPhase, boolean instancePhase, boolean start) throws SAXException {
        int i = 0;
        while (i < this.dataStructureBuilders.length) {
            IDataBuilder<?> dataBuilder = this.dataStructureBuilders[i];
            if (definitionPhase) {
                if (start) {
                    dataBuilder.startDefinitions();
                } else {
                    dataBuilder.endDefinitions();
                }
            }
            if (instancePhase) {
                if (start) {
                    dataBuilder.startInstances();
                } else {
                    dataBuilder.endInstances();
                }
            }
            if (dataBuilder.getPhase() == 3 || dataBuilder.getPhase() == this.phase || dataBuilder.getPhase() == 0 && (this.phase == 16 || this.phase == 1)) {
                if (start) {
                    dataBuilder.startElement(uri, localName, qName, attributes);
                } else {
                    dataBuilder.endElement(uri, localName, qName);
                }
            }
            ++i;
        }
        if (this.xmlValidation != null) {
            if (start) {
                this.xmlValidation.startElement(uri, localName, qName, attributes);
            } else {
                this.xmlValidation.endElement(uri, localName, qName);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int len) throws SAXException {
        this.eventNotification(1, ch, new int[]{start, len}, null);
        if (this.phase == 5) {
            this.remoteURI.append(new String(ch).substring(start, start + len));
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.eventNotification(3, null, null, null);
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        this.eventNotification(5, null, null, new String[]{arg0});
    }

    @Override
    public void unparsedEntityDecl(String arg0, String arg1, String arg2, String arg3) throws SAXException {
        super.unparsedEntityDecl(arg0, arg1, arg2, arg3);
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        this.eventNotification(6, arg0, new int[]{arg1, arg2}, null);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
        this.eventNotification(0, null, null, new String[]{arg0, arg1});
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        this.eventNotification(7, null, null, new String[]{arg0});
    }

    @Override
    public void startDocument() throws SAXException {
        this.eventNotification(2, null, null, null);
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.eventNotification(4, null, null, new String[]{arg0, arg1});
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.retrieveBuilders();
        int i = 0;
        while (i < this.dataStructureBuilders.length) {
            this.dataStructureBuilders[i].setDocumentLocator(locator);
            ++i;
        }
        if (this.xmlValidation != null) {
            this.xmlValidation.setDocumentLocator(locator);
        }
    }

    private void eventNotification(int event, char[] characters, int[] integerParameters, String[] stringParameters) throws SAXException {
        this.retrieveBuilders();
        int i = 0;
        while (i < this.dataStructureBuilders.length) {
            byte builderPhase = this.dataStructureBuilders[i].getPhase();
            if ((builderPhase == 3 || builderPhase == this.phase || builderPhase == 0 && (this.phase == 16 || this.phase == 1)) && this.isEventSupported(this.dataStructureBuilders[i], event)) {
                this.handleEvent(this.dataStructureBuilders[i], event, characters, integerParameters, stringParameters);
            }
            ++i;
        }
        if (this.xmlValidation != null) {
            this.handleEvent(this.xmlValidation, event, characters, integerParameters, stringParameters);
        }
    }

    @Override
    public void comment(char[] ch, int start, int len) throws SAXException {
        this.eventNotification(8, ch, new int[]{start, len}, null);
    }

    private boolean isEventSupported(IDataBuilder<?> dataBuilder, int event) {
        int supportedEvents = dataBuilder.getSupportedEvents();
        return (supportedEvents & 1 << event) > 0;
    }

    private void handleEvent(ContentHandler contentHandler, int event, char[] characters, int[] integerParameters, String[] stringParameters) throws SAXException {
        switch (event) {
            case 8: {
                ((IDataBuilder)contentHandler).comment(characters, integerParameters[0], integerParameters[1]);
                break;
            }
            case 1: {
                contentHandler.characters(characters, integerParameters[0], integerParameters[1]);
                break;
            }
            case 2: {
                contentHandler.startDocument();
                break;
            }
            case 3: {
                contentHandler.endDocument();
                break;
            }
            case 4: {
                contentHandler.startPrefixMapping(stringParameters[0], stringParameters[1]);
                break;
            }
            case 5: {
                contentHandler.endPrefixMapping(stringParameters[0]);
                break;
            }
            case 6: {
                contentHandler.ignorableWhitespace(characters, integerParameters[0], integerParameters[1]);
                break;
            }
            case 7: {
                contentHandler.skippedEntity(stringParameters[0]);
                break;
            }
            case 0: {
                contentHandler.processingInstruction(stringParameters[0], stringParameters[1]);
                break;
            }
        }
    }

    public boolean getStatus() {
        return this.status;
    }

    @Override
    public void addValidationListener(IValidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.validationListeners == null) {
            this.validationListeners = new ArrayList<IValidationListener>();
        }
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String arg0) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    @Override
    public void startEntity(String arg0) throws SAXException {
    }

    private class AttributeWrapper
    implements Attributes {
        private NamedNodeMap attributes;
        private Map<String, Integer> qNameInx;
        private Map<String, Integer> uriInx;

        public AttributeWrapper(NamedNodeMap attributes) {
            this.attributes = attributes;
            this.qNameInx = new Hashtable<String, Integer>();
            this.uriInx = new Hashtable<String, Integer>();
            if (attributes == null) {
                return;
            }
            int i = 0;
            int attributeCount = attributes.getLength();
            while (i < attributeCount) {
                Node att = attributes.item(i);
                Integer inx = new Integer(i);
                this.qNameInx.put(att.getNodeName(), inx);
                String key = att.getNamespaceURI() == null ? "" : att.getNamespaceURI();
                key = String.valueOf(key) + att.getLocalName();
                this.uriInx.put(key, inx);
                ++i;
            }
        }

        public int getIndex(String qName) {
            Integer inx = this.qNameInx.get(qName);
            return inx == null ? -1 : inx;
        }

        public int getIndex(String uri, String localName) {
            Integer inx = this.uriInx.get(uri == null ? localName : String.valueOf(uri) + localName);
            return inx == null ? -1 : inx;
        }

        public int getLength() {
            return this.attributes.getLength();
        }

        public String getLocalName(int index) {
            return this.attributes.item(index).getLocalName();
        }

        public String getQName(int index) {
            return this.attributes.item(index).getNodeName();
        }

        public String getType(int index) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getURI(int index) {
            return this.attributes.item(index).getNamespaceURI();
        }

        public String getValue(int index) {
            Node node = index >= 0 && index < this.attributes.getLength() ? this.attributes.item(index) : null;
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String qName) {
            Node node = this.attributes.getNamedItem(qName);
            return node == null ? null : node.getNodeValue();
        }

        public String getValue(String uri, String localName) {
            Node node = this.attributes.getNamedItemNS(uri, localName);
            return node == null ? null : node.getNodeValue();
        }
    }
}

