/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import java.net.URI;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.w3c.dom.Node;

public class CMDBfUtil {
    public static INodes retrieveRepositoryDocs(ISMLRepository repository, String templateId) throws RepositoryOperationException {
        INodes nodes = QueryOutputArtifactFactory.getInstance().createNodes(templateId);
        ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(null, 1, null, null, null));
        int i = 0;
        while (i < documents.length) {
            if (documents[i] instanceof IItemConvertible) {
                nodes.addItem((IItemConvertible)documents[i]);
            }
            ++i;
        }
        return nodes;
    }

    public static SMLFileInstanceDocument retrieveDocument(ISMLRepository repository, IItem item) throws RepositoryOperationException {
        IRecord[] records = item.getRecords();
        String recordId = "";
        if (records != null && records.length > 0) {
            URI id = records[0].getRecordMetadata().getRecordId();
            recordId = CMDBfServicesUtil.toString((URI)id);
        }
        if (recordId == null) {
            return null;
        }
        ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(recordId, -1, null, null, null));
        if (documents != null && documents.length > 0) {
            return (SMLFileInstanceDocument)documents[0];
        }
        return null;
    }

    public static Node retrieveDocumentNode(ISMLRepository repository, IItem item) throws RepositoryOperationException {
        SMLFileInstanceDocument document = CMDBfUtil.retrieveDocument(repository, item);
        return document == null ? null : document.getDOMDocument().getFirstChild();
    }
}

