/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementLocation;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ResourceWrapper;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationMessage;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.NodeIterator;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.content.DefinitionContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.content.InstanceContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.content.SMLIFContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DocumentDOMBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.DerefXPathFunction;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMLValidatorUtil {
    public static XPath xpath;
    private static SAXParserFactory saxParserFactory;

    static {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = xpath = factory == null ? null : factory.newXPath();
        if (xpath != null) {
            xpath.setXPathFunctionResolver(new XPathFunctionResolver(){

                public XPathFunction resolveFunction(QName functionName, int arity) {
                    if ("http://www.w3.org/2008/03/sml-function".equals(functionName.getNamespaceURI()) && "deref".equals(functionName.getLocalPart()) && arity == 1) {
                        return DerefXPathFunction.instance();
                    }
                    return null;
                }
            });
        }
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception exception) {
            saxParserFactory = null;
        }
    }

    public static Object retrieveDataStructure(String databuilderId) {
        IDataBuilder<?> databuilder = DataBuilderRegistry.instance().getDataStructureBuilder(databuilderId);
        if (databuilder == null) {
            return null;
        }
        return databuilder.getDataStructure();
    }

    public static String removeLineBreaks(String str, boolean replaceWithSpace) {
        if (str == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int lastChar = 0;
        int i = 0;
        int strLength = str.length();
        while (i < strLength) {
            char currentChar = str.charAt(i);
            if (currentChar != '\r' && (lastChar != 10 || currentChar != '\t' && currentChar != ' ')) {
                sb.append(currentChar == '\n' ? (replaceWithSpace ? " " : "") : String.valueOf(currentChar));
                lastChar = currentChar;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String removeLineBreaks(String str) {
        return SMLValidatorUtil.removeLineBreaks(str, true);
    }

    public static <T> Map<?, ?> retrieveNestedMap(Map<String, Map<String, T>> map, String key, boolean create) {
        if (key == null) {
            return null;
        }
        Map<String, T> nestedMap = map.get(key);
        if (create && nestedMap == null) {
            nestedMap = new Hashtable<String, T>();
            map.put(key, nestedMap);
        }
        return nestedMap;
    }

    /*
     * Exception decompiling
     */
    public static Node retrieveRemoteDocument(String uri) throws RemoteRetrievalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saxParseDocument(InputStream resource, DefaultHandler contentHandler) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
        saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        saxParserFactory.newSAXParser().parse(resource, contentHandler);
    }

    public static int identifyDocumentType(File resource) throws IOException, CoreException {
        FileInputStream fileInputStream = new FileInputStream(resource);
        try {
            int type = 3;
            Object[][] describer = new Object[][]{{new SMLIFContentDescriber(), new Integer(2)}, {new DefinitionContentDescriber(), new Integer(0)}, {new InstanceContentDescriber(), new Integer(1)}};
            BufferedReader br = new BufferedReader(new InputStreamReader(fileInputStream));
            StringBuffer sb = new StringBuffer();
            String input = null;
            while ((input = br.readLine()) != null) {
                sb.append(String.valueOf(input) + IValidationConstants.LINE_SEPARATOR);
            }
            int i = 0;
            while (i < describer.length) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(sb.toString().getBytes());
                if (((IContentDescriber)describer[i][0]).describe((InputStream)byteArrayInputStream, null) == 2) {
                    int n = (Integer)describer[i][1];
                    return n;
                }
                ++i;
            }
            int n = type;
            return n;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static int identifyDocumentType(IFile file) throws IOException, CoreException {
        int type = 3;
        InputStream fileInputStream = null;
        fileInputStream = file.exists() ? file.getContents() : new FileInputStream(file.getFullPath().toOSString());
        IContentType[] types = Platform.getContentTypeManager().findContentTypesFor(fileInputStream, file.getName());
        int i = 0;
        while (i < types.length) {
            if ("org.eclipse.cosmos.rm.validation.smlifContentType".equals(types[i].getId())) {
                return 2;
            }
            if ("org.eclipse.cosmos.rm.validation.definitionContentType".equals(types[i].getId())) {
                return 0;
            }
            if ("org.eclipse.cosmos.rm.validation.instanceContentType".equals(types[i].getId())) {
                type = 1;
            }
            ++i;
        }
        return type;
    }

    public static int identifyDocumentType(ResourceWrapper resourceWrapper) throws IOException, CoreException {
        return resourceWrapper.getResource() instanceof File ? SMLValidatorUtil.identifyDocumentType((File)resourceWrapper.getResource()) : SMLValidatorUtil.identifyDocumentType((IFile)resourceWrapper.getResource());
    }

    public static boolean deleteFileTree(File root) {
        if (root.exists()) {
            if (root.isFile()) {
                return root.delete();
            }
            File[] children = root.listFiles();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    SMLValidatorUtil.deleteFileTree(children[i]);
                    ++i;
                }
            }
            return root.delete();
        }
        return true;
    }

    public static Node[] retrieveChildElements(Node node) {
        if (node == null) {
            return new Node[0];
        }
        ArrayList<Node> childElements = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                childElements.add(child);
            }
            ++i;
        }
        return childElements.toArray(new Node[childElements.size()]);
    }

    public static String tagNameFor(String namespace, String elementName) {
        StringBuffer buffer = new StringBuffer("");
        if (namespace != null) {
            buffer.append(namespace).append(":");
        }
        buffer.append(elementName);
        return buffer.toString();
    }

    public static String beginTagFor(String elementName) {
        return SMLValidatorUtil.tagFor(false, null, elementName);
    }

    public static String beginTagFor(String namespace, String elementName) {
        return SMLValidatorUtil.tagFor(false, namespace, elementName);
    }

    public static String endTagFor(String elementName) {
        return SMLValidatorUtil.tagFor(true, null, elementName);
    }

    public static String endTagFor(String namespace, String elementName) {
        return SMLValidatorUtil.tagFor(true, namespace, elementName);
    }

    public static String tagFor(boolean end, String namespace, String elementName) {
        StringBuffer tagBuffer = new StringBuffer();
        tagBuffer.append("<");
        if (end) {
            tagBuffer.append("/");
        }
        tagBuffer.append(SMLValidatorUtil.tagNameFor(namespace, elementName));
        tagBuffer.append(">");
        return tagBuffer.toString();
    }

    public static String createElementTag(String elementName, String elementData) {
        return String.valueOf(SMLValidatorUtil.beginTagFor(elementName)) + elementData + SMLValidatorUtil.endTagFor(elementName);
    }

    public static String createElementTag(String namespace, String elementName, String elementData) {
        return String.valueOf(SMLValidatorUtil.beginTagFor(namespace, elementName)) + elementData + SMLValidatorUtil.endTagFor(namespace, elementName);
    }

    public static String getExceptionStackTrace(Throwable t) {
        if (t == null) {
            return "";
        }
        Throwable throwable = SMLValidatorUtil.findCause(t);
        StringWriter stackTrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stackTrace));
        return stackTrace.toString();
    }

    protected static Throwable findCause(Throwable t) {
        Throwable cause = null;
        if (t instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)t).getTargetException();
        } else if (t instanceof CoreException) {
            cause = ((CoreException)t).getStatus().getException();
        }
        if (cause == null) {
            return t;
        }
        return SMLValidatorUtil.findCause(cause);
    }

    /*
     * Unable to fully structure code
     */
    public static String stringReplace(String originalString, String oldSubstring, String newSubstring) {
        result = new StringBuffer();
        index = 0;
        if (newSubstring != null) ** GOTO lbl14
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            prevIndex = index;
            if (index + oldSubstring.length() <= originalString.length() && (oldSubstring.length() == 0 || originalString.substring(index, index + oldSubstring.length()).equals(oldSubstring))) {
                result.append(newSubstring);
                index += oldSubstring.length();
            }
            if (prevIndex != index && !"".equals(oldSubstring)) continue;
            result.append(originalString.charAt(index));
            ++index;
lbl14:
            // 3 sources

            ** while (index < originalString.length())
        }
lbl15:
        // 1 sources

        return result.toString();
    }

    public static IValidationMessage createValidationMessage(DocumentDOMBuilder builder, Node node, String error) {
        if (!(node instanceof Element)) {
            return AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(-1, error);
        }
        ElementLocation elementLocation = builder.getLocation((Element)node);
        return AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(elementLocation == null ? null : elementLocation.getFilePath(), elementLocation == null ? -1 : elementLocation.getLineNumber(), error);
    }

    public static SAXParser createSAXParser(Object schemaSource, boolean validating, LexicalHandler lexicalHandler, IValidationOutput<String, Object> validationLogger) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParserFactory saxParserFactory = SMLValidatorUtil.saxParserFactory;
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            saxParserFactory.setValidating(validating);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SMLValidatorUtil.saxParserFactory = saxParserFactory;
        }
        saxParserFactory.setFeature("http://xml.org/sax/features/validation", validating);
        SAXParser newSaxParser = saxParserFactory.newSAXParser();
        if (schemaSource == null) {
            return newSaxParser;
        }
        try {
            newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            newSaxParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schemaSource);
            if (lexicalHandler != null) {
                newSaxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            }
        }
        catch (Exception exception) {
            validationLogger.reportMessage(AbstractValidationOutput.ValidationMessageFactory.createWarningMessage(-1, SMLValidationMessages.errorUnsupportedSAXProperty0));
            saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
            newSaxParser = saxParserFactory.newSAXParser();
        }
        return newSaxParser;
    }

    public static String retrieveAbsolutePath(String path) {
        Path resourcePath = new Path(path);
        if (resourcePath.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(resourcePath.segment(0)).getLocation().toOSString();
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        if (file != null && SMLValidatorUtil.checkWorkspaceResourceName(path)) {
            return file.getLocation().toOSString();
        }
        return path;
    }

    public static boolean checkWorkspaceDirName(String dirName) {
        boolean okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 2).isOK();
        if (!okForFolder) {
            okForFolder = ResourcesPlugin.getWorkspace().validatePath(dirName, 4).isOK();
        }
        return okForFolder;
    }

    public static boolean checkWorkspaceResourceName(String resourceName) {
        if (!resourceName.startsWith("/")) {
            resourceName = String.valueOf('/') + resourceName;
        }
        return ResourcesPlugin.getWorkspace().validatePath(resourceName, 1).isOK();
    }

    public static boolean isReference(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        Node refAttribute = attributes.getNamedItemNS("http://www.w3.org/2008/03/sml", "ref");
        return SMLValidatorUtil.isTrue(refAttribute == null ? null : refAttribute.getNodeValue());
    }

    public static boolean isAcyclic(Attributes attributes) {
        return SMLValidatorUtil.isTrue(attributes.getValue("http://www.w3.org/2008/03/sml", "acyclic"));
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return "true".equals(value = value.trim()) || "1".equals(value);
    }

    public static String extractReference(Node root) {
        NodeIterator nodeIterator = new NodeIterator(root, "http://www.w3.org/2008/03/sml", "uri");
        if (!nodeIterator.hasNext()) {
            return "";
        }
        Node uriElement = nodeIterator.next();
        NodeList children = uriElement.getChildNodes();
        StringBuffer reference = new StringBuffer();
        int i = 0;
        int childCount = children.getLength();
        while (i < childCount) {
            if (children.item(i).getNodeType() == 3) {
                String value = children.item(i).getNodeValue();
                value = value.trim();
                value = value.replaceAll("\n", "");
                reference.append(value);
            }
            ++i;
        }
        return reference.toString();
    }

    public static QName toQName(Map<String, String> prefixUriMap, String targetNamespace, String value) {
        if (value == null) {
            return null;
        }
        String[] tokenizedValue = value.split(":");
        if (tokenizedValue.length >= 2) {
            return new QName(prefixUriMap.get(tokenizedValue[0]), tokenizedValue[1], tokenizedValue[0]);
        }
        return new QName(targetNamespace, tokenizedValue[0]);
    }

    public static boolean isBuiltInNamespace(String namespace) {
        return namespace != null && namespace.equals("http://www.w3.org/2008/03/sml") || namespace.equals("http://purl.oclc.org/dsdl/schematron") || namespace.equals("http://www.w3.org/2008/03/sml-if") || namespace.equals("http://www.w3.org/2001/XMLSchema") || namespace.equals("http://www.w3.org/2008/03/sml-function") || namespace.equals("http://www.w3.org/1999/xlink") || namespace.equals("http://www.w3.org/2001/XMLSchema-instance") || namespace.equals("http://www.w3.org/1999/XSL/Transform");
    }

    public static class RemoteRetrievalException
    extends Exception {
        private static final long serialVersionUID = 7633895444717500045L;

        public RemoteRetrievalException(String message) {
            super(message);
        }

        public RemoteRetrievalException(Exception cause) {
            super(cause);
        }
    }
}

