/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.cosmos.rm.internal.validation.artifacts.DocumentNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementEdge;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementTypeMap;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceGraphDataBuilder
extends AbstractDataBuilder<Map<String, DocumentNode>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ReferenceGraphDataBuilder";
    private Map<String, DocumentNode> referenceGraph = new Hashtable<String, DocumentNode>();
    private DocumentNode currentNode;
    private boolean aliasElementHit;
    private boolean uriElementHit;
    private ElementNode srcReferenceNode;
    private ElementNode lastElement = new ElementNode();
    private ElementEdge elementEdge;
    private String currentAlias = "";
    private IDataBuilder<ElementTypeMap> elementTypeMapBuilder;

    public ReferenceGraphDataBuilder() {
        this.srcReferenceNode = new ElementNode();
        super.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.resetElementStartStatus();
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("document".equals(localName)) {
                this.currentNode = new DocumentNode();
            } else if ("alias".equals(localName)) {
                this.aliasElementHit = true;
            }
        } else if ("http://www.w3.org/2008/03/sml".equals(uri) && "uri".equals(localName)) {
            this.uriElementHit = true;
            this.srcReferenceNode.setName(this.lastElement.getName());
            this.srcReferenceNode.setUri(this.lastElement.getUri());
        }
        this.lastElement.setName(localName);
        this.lastElement.setUri(uri);
    }

    private void resetElementStartStatus() {
        this.aliasElementHit = false;
        this.elementEdge = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String textNode = new String(ch, start, length).trim();
        if (this.currentNode == null || textNode.length() <= 0) {
            return;
        }
        if (this.aliasElementHit) {
            this.currentAlias = String.valueOf(this.currentAlias) + textNode;
        } else if (this.uriElementHit) {
            if (this.elementEdge == null) {
                if (this.elementTypeMapBuilder == null) {
                    this.elementTypeMapBuilder = DataBuilderRegistry.instance().getDataStructureBuilder("org.eclipse.cosmos.rm.validation.ElementTypeMapDataBuilder");
                }
                ElementTypeMap elementTypeMap = null;
                String referenceType = null;
                if (this.elementTypeMapBuilder == null || (elementTypeMap = this.elementTypeMapBuilder.getDataStructure()) == null || (referenceType = elementTypeMap.getType(this.srcReferenceNode)) == null) {
                    return;
                }
                this.elementEdge = new ElementEdge(this.srcReferenceNode.getUri(), referenceType, this.locator.getLineNumber());
            }
            this.elementEdge.appendToReference(textNode);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentNode == null) {
            return;
        }
        if ("http://www.w3.org/2008/03/sml-if".equals(uri)) {
            if ("document".equals(localName)) {
                String[] aliases = this.currentNode.getAliases();
                if (aliases == null) {
                    return;
                }
                int i = 0;
                while (i < aliases.length) {
                    this.referenceGraph.put(aliases[i], this.currentNode);
                    ++i;
                }
                this.currentNode = null;
            } else if ("alias".equals(localName)) {
                this.currentNode.addAlias(this.currentAlias);
                this.currentAlias = "";
            }
        } else if ("http://www.w3.org/2008/03/sml".equals(uri) && "uri".equals(localName) && this.elementEdge != null) {
            this.currentNode.addEdge(this.elementEdge);
        }
    }

    @Override
    public Map<String, DocumentNode> getDataStructure() {
        return this.referenceGraph;
    }

    @Override
    public byte getPhase() {
        return 0;
    }
}

