/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TypeDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TypeDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDeclarationBuilder;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderUtil;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclarationBuilder
extends AbstractDeclarationBuilder<TypeDeclarationCollection> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.TypeDeclarationBuilder";
    private TypeDeclarationCollection datastructure = new TypeDeclarationCollection();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        if (!"http://www.w3.org/2001/XMLSchema".equals(uri)) {
            return;
        }
        if ("complexType".equals(localName)) {
            this.setDeclaration(this.setCommonFields(attributes, new TypeDeclaration()));
        } else if (this.getDeclaration() != null) {
            TypeDeclaration baseRestrictionDeclaration;
            QName baseRestriction;
            TypeDeclaration typeDeclaration = (TypeDeclaration)this.getDeclaration();
            if ("restriction".equals(localName) && (baseRestriction = SMLValidatorUtil.toQName(this.getPrefixMap(), this.getTargetNamespace(), this.retrieveValue(attributes, "http://www.w3.org/2001/XMLSchema", "base"))) != null && (baseRestrictionDeclaration = (TypeDeclaration)this.datastructure.get(baseRestriction)) != null) {
                typeDeclaration.setBaseRestriction(baseRestrictionDeclaration);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        super.endElement(uri, localName, name);
        if (!"http://www.w3.org/2001/XMLSchema".equals(uri) || this.getDeclaration() == null) {
            return;
        }
        if ("complexType".equals(localName)) {
            this.datastructure.add((TypeDeclaration)this.getDeclaration());
            this.setDeclaration(null);
        }
    }

    @Override
    public byte getPhase() {
        return 1;
    }

    @Override
    public TypeDeclarationCollection getDataStructure() {
        return this.datastructure;
    }

    @Override
    public boolean isStructureValid() {
        for (TypeDeclaration typeDeclaration : this.datastructure) {
            if (this.isConsistent(typeDeclaration)) continue;
            return false;
        }
        return true;
    }

    private boolean isConsistent(TypeDeclaration typeDeclaration) {
        Map<QName, List<ConstraintNode>> elementDeclarations = this.retrieveDuplicateDeclarations(typeDeclaration);
        if (!this.isConsistent(elementDeclarations)) {
            this.setErrorMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(typeDeclaration.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.targetInconsistentDeclarations, (Object)typeDeclaration.getQName().toString())));
            return false;
        }
        TypeDeclaration baseRestriction = typeDeclaration.getBaseRestriction();
        if (baseRestriction == null) {
            return true;
        }
        for (ConstraintNode localElementDeclaration : typeDeclaration.getElementDeclarations()) {
            ConstraintNode parentLocalElementDeclaration = baseRestriction.getElementDeclarations().get(new QName(localElementDeclaration.getUri(), localElementDeclaration.getName()));
            if (parentLocalElementDeclaration == null || this.isEqual(localElementDeclaration, parentLocalElementDeclaration)) continue;
            this.setErrorMessage(AbstractValidationOutput.ValidationMessageFactory.createErrorMessage(typeDeclaration.getLocation().getLineNumber(), NLS.bind((String)SMLValidationMessages.targetBadDerivation, (Object)typeDeclaration.getQName().toString())));
            return false;
        }
        return true;
    }

    private Map<QName, List<ConstraintNode>> retrieveDuplicateDeclarations(TypeDeclaration typeDeclaration) {
        Hashtable<QName, List<ConstraintNode>> duplicates = new Hashtable<QName, List<ConstraintNode>>();
        ArrayList<ElementDeclarationCollection> allDeclarations = new ArrayList<ElementDeclarationCollection>();
        ElementDeclarationCollection localCollection = typeDeclaration.getElementDeclarations();
        if (localCollection != null) {
            allDeclarations.add(localCollection);
        }
        GroupDeclarationCollection groupCollection = typeDeclaration.getGroupDeclarations();
        for (GroupDeclaration group : groupCollection) {
            if (group.getRef() != null) {
                group = DataBuilderUtil.retrieveGroup(group.getRef());
            }
            if (group == null) continue;
            ElementDeclarationCollection groupElementCollection = group.getElementDeclarations();
            for (ConstraintNode groupElementDeclaration : groupElementCollection) {
                this.addDuplicates(duplicates, allDeclarations, groupElementDeclaration);
            }
            allDeclarations.add(groupElementCollection);
        }
        return duplicates;
    }

    private void addDuplicates(Map<QName, List<ConstraintNode>> duplicates, List<ElementDeclarationCollection> allDeclarations, ConstraintNode element) {
        QName qName = element.getName() == null ? element.getRef() : new QName(element.getUri(), element.getName());
        boolean elementAdded = false;
        for (ElementDeclarationCollection elementDeclarationCollection : allDeclarations) {
            ConstraintNode currentElement = elementDeclarationCollection.get(qName);
            if (currentElement == null) continue;
            List<ConstraintNode> list = duplicates.get(qName);
            if (list == null) {
                list = new ArrayList<ConstraintNode>();
                duplicates.put(qName, list);
            }
            list.add(currentElement);
            if (elementAdded) continue;
            elementAdded = true;
            list.add(element);
        }
    }

    private boolean isConsistent(Map<QName, List<ConstraintNode>> elementDeclarations) {
        for (QName qName : elementDeclarations.keySet()) {
            List<ConstraintNode> duplicatedEntries = elementDeclarations.get(qName);
            int i = 1;
            int duplicateCount = duplicatedEntries.size();
            while (i < duplicateCount) {
                if (!this.isEqual(duplicatedEntries.get(0), duplicatedEntries.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean isEqual(ConstraintNode targetSchemaNode1, ConstraintNode targetSchemaNode2) {
        return this.isEqual(targetSchemaNode1.getTargetElement(), targetSchemaNode2.getTargetElement()) && this.isEqual(targetSchemaNode1.getTargetType(), targetSchemaNode2.getTargetType()) && this.isEqual(targetSchemaNode1.getTargetRequired(), targetSchemaNode2.getTargetRequired());
    }

    private boolean isEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }
}

