/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.repository.operations.cmdbf;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IItemConvertible;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.INodes;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.QueryOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRecord;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileInstanceDocument;
import org.eclipse.cosmos.rm.internal.repository.resource.SMLFileMetadata;
import org.eclipse.cosmos.rm.provisional.repository.core.ISMLRepository;
import org.eclipse.cosmos.rm.provisional.repository.exception.RepositoryOperationException;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLDocument;
import org.eclipse.cosmos.rm.provisional.repository.resource.ISMLMetadata;
import org.w3c.dom.Node;

/**
 * Provides common utility methods used by constraint handlers
 * 
 * @author Ali Mehregani
 */
public class CMDBfUtil
{

	public static INodes retrieveRepositoryDocs (ISMLRepository repository, String templateId) throws RepositoryOperationException
	{
		INodes nodes = QueryOutputArtifactFactory.getInstance().createNodes(templateId);		
		ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(null,ISMLMetadata.DOCUMENT_TYPE_INSTANCE, null, null, null));		
		for (int i = 0; i < documents.length; i++)
		{
			if (documents[i] instanceof IItemConvertible)
			{
				nodes.addItem((IItemConvertible) documents[i]);
			}		
		}
		
		return nodes;
	}
	
	public static SMLFileInstanceDocument retrieveDocument(ISMLRepository repository, IItem item) throws RepositoryOperationException
	{
		IRecord[] records = (IRecord[]) item.getRecords();
		String recordId = "";
		if (records != null && records.length > 0)
		{
			URI id  = records[0].getRecordMetadata().getRecordId();			
			recordId = CMDBfServicesUtil.toString(id);
		}
		
		if (recordId == null)
		{
			return null;
		}
	
		ISMLDocument[] documents = repository.fetchDocuments(new SMLFileMetadata(recordId, ISMLMetadata.DOCUMENT_TYPE_NONE, null, null, null));
		if (documents != null && documents.length > 0)
		{
			return (SMLFileInstanceDocument)documents[0];
		}
		return null;
	}
	
	public static Node retrieveDocumentNode(ISMLRepository repository, IItem item) throws RepositoryOperationException
	{
		SMLFileInstanceDocument document = retrieveDocument(repository, item);
		return document == null ? null : document.getDOMDocument().getFirstChild();					
	}
}
