/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import javax.xml.namespace.QName;

import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;

/**
 * TargetSchemaNode a schema element that has an associated
 * target* constraint
 * 
 * @author sleeloy
 * @author Ali Mehregani
 */
public class ConstraintNode extends ElementNode 
{	
	/**
	 * The substitution group
	 */
	private ConstraintNode substitutionGroup;
	
	/**
	 * Value of sml:targetRequired
	 */
	private Boolean targetRequired;
	
	/**
	 * Value of sml:targetElement
	 */
	private QName targetElement;
	
	/**
	 * Value of sml:targetType
	 */
	private QName targetType;
	
	
	public ConstraintNode() 
	{
		super();
	}

	
	public ConstraintNode(String name, String filePath, int line, int column) 
	{
		super(name, filePath, line, column);
	}

	public ConstraintNode getSubstitutionGroup() 
	{
		return substitutionGroup;
	}

	
	public void setSubstitutionGroup(ConstraintNode substitutionGroup) 
	{
		this.substitutionGroup = substitutionGroup;
	}
	
	
	public boolean getTargetRequired() 
	{
		if (targetRequired == null && substitutionGroup != null)
			return substitutionGroup.getTargetRequired();
		return targetRequired == null ? false : targetRequired;
	}

	
	public void setTargetRequired(String required) 
	{
		this.targetRequired = required == null ? null : SMLValidatorUtil.isTrue(required);
	}

	
	public QName getTargetElement() 
	{
		if (targetElement == null && substitutionGroup != null)
			return substitutionGroup.getTargetElement();
		return targetElement;
	}

	
	public void setTargetElement(String uri, String localName) 
	{
		this.targetElement = new QName(uri, localName);
	}

	
	public void setTargetElement(QName targetElement)
	{
		this.targetElement = targetElement;		
	}
	
	
	public QName getTargetType() 
	{
		if (targetType == null && substitutionGroup != null)
			return substitutionGroup.getTargetType();
		return targetType;
	}

	
	public void setTargetType(String uri, String localName) 
	{
		this.targetType = new QName(uri, localName);
	}
	
	
	public void setTargetType(QName targetType) 
	{
		this.targetType = targetType;
	}
}
