/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;


/**
 * Used to store location detail about an element
 * 
 * @author Ali Mehregani
 */
public class ElementLocation implements Comparable<ElementLocation>
{
	/**
	 * The path of the file containing an element
	 */
	private String filePath;
	
	/**
	 * The line number of the file containing the element
	 */
	private int lineNumber;

	/**
	 * The column number of the node
	 */
	private int columnNumber;
	
	public ElementLocation(String filePath, int lineNumber)
	{
		this.filePath = filePath;
		this.lineNumber = lineNumber;
	}
	
	public ElementLocation(String filePath, int lineNumber, int columnNumber)
	{
		this(filePath, lineNumber);
		this.columnNumber = columnNumber;		
	}

	/**
	 * @return the filePath
	 */
	public String getFilePath()
	{
		return filePath;
	}

	/**
	 * @param filePath the filePath to set
	 */
	public void setFilePath(String filePath)
	{
		this.filePath = filePath;
	}

	/**
	 * @return the lineNumber
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}

	/**
	 * @param lineNumber the lineNumber to set
	 */
	public void setLineNumber(int lineNumber)
	{
		this.lineNumber = lineNumber;
	}

	/**
	 * @return the columnNumber
	 */
	public int getColumnNumber()
	{
		return columnNumber;
	}

	/**
	 * @param columnNumber the columnNumber to set
	 */
	public void setColumnNumber(int columnNumber)
	{
		this.columnNumber = columnNumber;
	}

	public int compareTo(ElementLocation arg0) 
	{
		
		ElementLocation location2 = (ElementLocation) arg0;
		if (lineNumber == location2.getLineNumber()) {
			return compare(columnNumber, location2.getColumnNumber());
		}
		return compare(lineNumber, location2.getLineNumber());
	}
	
	public static final int compare(final int left, final int right) {
		return left - right;
	}
}
