/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.rm.internal.validation.reference.ReferenceContext;

public class ReferenceDescriptor
{
	private int lineNumber;
	private String filePath;
	private String reference;
	private ReferenceContext context;
	
	/**
	 * store the list of aliases for contained element; it will be used to 
	 * resolve base URI for this reference
	 */
	private List<String> aliases;
	
	/**
	 * Used when the containing document has no aliases
	 * In this case, the document is located by its position
	 * within the documents with no aliases
	 */
	private int documentPosition;
	
	
	public ReferenceDescriptor(String filePath, int lineNumber, String reference, List<String> aliases, int documentPosition)
	{
		this.filePath = filePath;
		this.lineNumber = lineNumber;
		this.reference = reference;
		this.aliases = aliases;
		this.documentPosition = documentPosition;
	}
	
	/**
	 * @return the lineNumber
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}
	/**
	 * @return the filePath
	 */
	public String getFilePath()
	{
		return filePath;
	}
	/**
	 * @return the reference
	 */
	public String getReference()
	{
		return reference;
	}

	/**
	 * @return the aliases
	 */
	public List<String> getAliases() {
		return aliases;
	}

	/**
	 * @param aliases the aliases to set
	 */
	public void setAliases(List<String> aliases) {
		this.aliases = aliases;
	}	
	
	/**
	 * 
	 * @param alias
	 */
	public void addAlias(String alias)
	{
		if(aliases == null)
			aliases = new ArrayList<String>();
		
		if(alias != null)
			aliases.add(alias);
	}

	/**
	 * @return the documentPosition
	 */
	public int getDocumentPosition() {
		return documentPosition;
	}

	/**
	 * @param documentPosition the documentPosition to set
	 */
	public void setDocumentPosition(int documentPosition) {
		this.documentPosition = documentPosition;
	}

	public void setContext(ReferenceContext refContext) {
		
		context = refContext;
	}

	/**
	 * @return the context
	 */
	public ReferenceContext getContext() {
		return context;
	}
}
