/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.artifacts;

/**
 * Currently schema bindings is not supported by the validator.  According to the
 * specification consumers of SML-IF documents are not required to support schema bindings:
 * 
 * "SML-IF consumers MAY choose to ignore the schemaBindings element when present in the 
 * SML-IF document, in which case the consumer SHOULD make its invoker aware of this situation. 
 * The remainder of this section applies to SML-IF consumers who choose to process the schemaBindings 
 * element."
 * See {@link http://www.w3.org/TR/2008/WD-sml-if-20080114/#Schema_Document_Bindings1}
 * 
 * @author Ali Mehregani
 */
public class SchemaBindings
{
	
}
