/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

import org.eclipse.cosmos.rm.internal.validation.core.IValidator;

public class FileOutput extends TextOutput
{	
	/**
	 * The file that will be written to
	 */
	private File file;
	
	/**
	 * The buffered writer
	 */
	private BufferedWriter bufferedWriter;
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput#initialize(java.util.Map)
	 */
	public void initialize(Map<String, Object> attributes)
	{
		super.initialize(attributes);
		String filePath = (String)attributes.get(IValidator.ATTRIBUTE_FILE_OUTPUT);
		OutputStream fileOutput;
		try
		{
			if (filePath != null)
			{				
				file = new File(filePath);
				fileOutput = new FileOutputStream(filePath);
				bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutput));
				return;
			}
		} 
		catch (FileNotFoundException e)
		{			
		}
		
		/* Print to system output */
		file = null;

	}
	
	public String getFilePath()
	{
		if (file == null)
			return SMLValidationMessages.outputSystem;
		return file.getAbsolutePath();
	}

	protected void writeMessage(String message)
	{
		try
		{
			if (bufferedWriter == null) {
				bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
			}
			
			bufferedWriter.write(message + IValidationConstants.LINE_SEPARATOR);
			bufferedWriter.flush();
		} catch (IOException e)
		{
			file = null;
			bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));			
		}				
	}

	public void close()
	{
		try
		{
			if (bufferedWriter != null)
				bufferedWriter.close();
		} catch (IOException e)
		{
			/* Ignore the error */
		}
	}

}
