/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.common;

import org.xml.sax.Attributes;

/**
 * Contains constants commonly used by multiple classes
 * 
 * @author Ali Mehregani
 */
public interface IValidationConstants
{
	/**
	 * Miscellaneous constants
	 */
	public static final String EMPTY_STRING = "";
	public static final String LINE_SEPARATOR = System.getProperty("line.separator");
	public static final String TRUE_VALUE = "true";
	public static final String DUMMY_BASE_URI = "";
	public static final String ONE_VALUE = "1";
	
	/**
	 * The amount work required by a validation run
	 */
	public static final int VALIDATION_WORK = 7; 
	
	
	/**
	 * Known file extensions
	 */
	public static final String EXTENSION_SCHEMA = "xsd";	
	public static final String EXTENSION_SML = "xml";
	
	/**
	 * An empty attribute
	 */
	public static final Attributes EMPTY_ATTRIBUTES = new Attributes(){

		public int getIndex(String qName)
		{
			return -1;
		}

		public int getIndex(String uri, String localName)
		{
			return -1;
		}

		public int getLength()
		{
			return 0;
		}

		public String getLocalName(int index)
		{
			return null;
		}

		public String getQName(int index)
		{
			return null;
		}

		public String getType(int index)
		{
			return null;
		}

		public String getType(String qName)
		{
			return null;
		}

		public String getType(String uri, String localName)
		{
			return null;
		}

		public String getURI(int index)
		{
			return null;
		}

		public String getValue(int index)
		{
			return null;
		}

		public String getValue(String qName)
		{
			return null;
		}

		public String getValue(String uri, String localName)
		{
			return null;
		}};	
}
