/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.content;

import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.cosmos.rm.internal.validation.SMLActivator;

/**
 * The instance content describer
 * 
 * @author Ali Mehregani
 */
public class InstanceContentDescriber extends AbstractXMLContentDescriber
{
	/**
	 * The content type id for instance documents
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".instanceContentType";
	
	/**
	 * @see org.eclipse.cosmos.rm.smlif.internal.content.AbstractXMLContentDescriber#determineType(java.lang.String)
	 */
	public int determineType(String line)
	{
		// Assume valid, since there is nothing distinctive about an SML instance document
		return IContentDescriber.VALID;
	}

}
