/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.core;


/**
 * This is an abstract implementation of ISMLValidation.
 * 
 * @author Ali Mehregani
 */
public abstract class AbstractSMLValidator extends AbstractValidator implements ISMLValidator
{	
	/**
	 * The scope of this validation class
	 */
	private String[] scope;

	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.core.ISMLValidator#getScope()
	 */
	public String[] getScope()
	{
		return scope;
	}

	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.core.ISMLValidator#setScope(java.lang.String[])
	 */
	public void setScope(String[] scope)
	{
		this.scope = scope;
	}


	protected boolean shouldAbortOnError() {
		ValidationEvent validationEvent = new ValidationEvent();
		fireValidationEventOccurred(validationEvent);
		return validationEvent.abortOnError();
	}

}
