/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.Iterator;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TypeNode;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.eclipse.cosmos.rm.internal.validation.common.IValidationConstants;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput.ValidationMessageFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * This data structure stores a list of elements that are of type
 * acyclic.
 * 
 * @author Ali Mehregani
 */
public class AcyclicDataTypesList extends AbstractPropertyExtractor<Iterator<TypeNode>>
{
	/**
	 * The ID of this data type builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".AcyclicDataTypesList";
			
	
	/**
	 * Constructor
	 */
	public AcyclicDataTypesList()
	{
		super(ISMLConstants.DEFINITIONS_PHASE, null, 
					new String[][]{new String[]{
						ISMLConstants.SML_URI,
						ISMLConstants.ACYCLIC_ATTRIBUTE, 
						IValidationConstants.TRUE_VALUE}}, 
					new String[]{
						ISMLConstants.NAME_ATTRIBUTE, 
						null
					});		
	}
	
	@Override
	public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException
	{
		// Display a warning message if sml:acyclic is defined on any elements other than a type declaration
		if (ISMLConstants.SCHEMA_URI.equals(uri) && !ISMLConstants.COMPLEXTYPE_ELEMENT.equals(localName) && SMLValidatorUtil.isAcyclic(attributes))
		{
			getMessageOutputter().reportMessage(
					ValidationMessageFactory.createWarningMessage(
							locator.getLineNumber(), SMLValidationMessages.acyclicBadDeclaration));
		}
					
		super.startElement(uri, localName, name, attributes);		
	}
	
	protected String getValueToStoreNS()
	{
		return super.getTargetNamespace();
	}

	
	public Iterator<TypeNode> getDataStructure()
	{
		return super.getIteratorDataStructure();
	}
}
