/**********************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclaration;
import org.eclipse.cosmos.rm.internal.validation.artifacts.GroupDeclarationCollection;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GroupDeclarationBuilder extends AbstractDeclarationBuilder<GroupDeclarationCollection>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".GroupDeclarationBuilder";
	
	/**
	 * The data structure used to keep track of all group declarations
	 */
	private GroupDeclarationCollection datastructure;
	
	
	public GroupDeclarationBuilder()
	{
		datastructure = new GroupDeclarationCollection();
	}
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDataBuilder#startElement(java.lang.String, java.lang.String, java.lang.String, org.xml.sax.Attributes)
	 */
	@Override
	public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException
	{		
		String lastElement = getLastElement();
		super.startElement(uri, localName, name, attributes);
		
		if (!ISMLConstants.SCHEMA_URI.equals(uri))
		{
			return;
		}
		
		if (ISMLConstants.GROUP_ELEMENT.equals(localName) && ISMLConstants.SCHEMA_ELEMENT.equals(lastElement))
		{
			setDeclaration(setCommonFields(attributes, new GroupDeclaration()));						
		}
	}
	
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractDeclarationBuilder#endElement(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override
	public void endElement(String uri, String localName, String name) throws SAXException
	{		
		super.endElement(uri, localName, name);
		
		if (!ISMLConstants.SCHEMA_URI.equals(uri) || getDeclaration() == null)
		{
			return;
		}
		
		if (ISMLConstants.GROUP_ELEMENT.equals(localName))
		{
			datastructure.add((GroupDeclaration)getDeclaration());
			setDeclaration(null);
		}				
	}
	
	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.databuilders.IDataBuilder#getDataStructure()
	 */
	public GroupDeclarationCollection getDataStructure()
	{		
		return datastructure;
	}

}
