/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementNode;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.eclipse.cosmos.rm.internal.validation.core.IFoundationBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * This builder will build a lookup map that will key on alias names.  The value is the 
 * root element name of the document.
 * @author sleeloy
 */
public class RootElementAliasLookupBuilder extends AbstractDataBuilder<Map<List<String>, String[]>>
{

	public static final String ID = SMLActivator.PLUGIN_ID + ".RootElementAliasLookupBuilder";
	protected List<String> targetElements;
	protected String[] rootDocElement;
    Map<List<String>, String[]> rootElementAlias = new HashMap<List<String>, String[]>();
    protected ElementNode currentTargetElement; 
    protected boolean aliasFound = false; 
    protected boolean dataFound = false; 
    protected boolean rootElem = false;
	
    public RootElementAliasLookupBuilder()
    {
    	super.addEvent(IFoundationBuilder.EVENT_CHARACTER);
    }
    
    public Map<List<String>, String[]> getDataStructure() {
		return rootElementAlias;
	}

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		
		if (ISMLConstants.ALIASES_ELEMENT.equals(localName)){
			targetElements = new ArrayList<String>();			
		}
		else if (ISMLConstants.ALIAS_ELEMENT.equals(localName)){
			aliasFound = true;
		}
		else if (ISMLConstants.DATA_ELEMENT.equals(localName)){
			dataFound = true;
			rootElem = true;
		}
		else if ((dataFound) && (targetElements != null)){
			if (rootElem){
				rootElem = false;
				rootDocElement = new String[2];
				rootDocElement[0] = localName;
				rootDocElement[1] = uri;
				dataFound = false;
			}
		}
	}

	
	public void characters(char[] ch, int start, int len) throws SAXException {
		//extract the uri value
		if (aliasFound){
			String target = new String(ch, start, len);
			targetElements.add(target);
		}
	}

	public void endElement(String uri, String localName, String qName) throws SAXException {
		if ((dataFound) && (ISMLConstants.DATA_ELEMENT.equals(localName))){
			dataFound = false;
			rootElem = false;
		}
		else if (ISMLConstants.ALIAS_ELEMENT.equals(localName)){
			aliasFound = false;
		}
//		else if (ISMLConstants.ALIASES_ELEMENT.equals(qName)){
//			aliasFound = false;
//		}
		else if (dataFound && !rootElem){
			rootElem = true;			
		}
		else if (ISMLConstants.DOCUMENT_ELEMENT.equals(localName)){
			if ((targetElements != null) && (rootDocElement != null))
				rootElementAlias.put(targetElements, rootDocElement);
			rootDocElement = null;			
			targetElements = null;
		}
	}

	public byte getPhase() {
		return ISMLConstants.INSTANCES_PHASE;
	}

}
