package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ElementNode;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.eclipse.cosmos.rm.internal.validation.core.IFoundationBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
/**
 * This builder will build a datastructure that will contian all elements with 
 * element tag name

 * @author sleeloy
 * @author David Whiteman
 */
public class SMLValidatingBuilder extends AbstractDataBuilder<Map<String, ElementNode>>
{

	public static final String ID = SMLActivator.PLUGIN_ID + ".SMLValidatingBuilder";
    Map<String, ElementNode> typeElements = new HashMap<String, ElementNode>();

    public SMLValidatingBuilder()
    {
    	super.addEvent(IFoundationBuilder.EVENT_CHARACTER);
    }
    
	public  Map<String, ElementNode> getDataStructure() {
		return typeElements;
	}
		
	public void error(SAXParseException parseException) throws SAXException 
	{
		throw parseException;
	}
	
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException 
	{
	}

	public byte getPhase() 
	{
		return ISMLConstants.DEFINITIONS_PHASE;
	}

	public void characters(char[] ch, int start, int length) throws SAXException {
	}

	public void endElement(String uri, String localName, String qName) throws SAXException 
	{
	}
}
