/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.Map;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;

/**
 * This builder will create a list of elements 
 * @author sleeloy
 *
 */
public class SubstitutionBuilder extends AbstractPropertyExtractor<Map<String, Map<String, String>>>
{
	/**
	 * The ID of this builder
	 */
	public static final String ID = SMLActivator.PLUGIN_ID + ".SubstitutionBuilder";

	public SubstitutionBuilder() {
    	super(ISMLConstants.DEFINITIONS_PHASE, ISMLConstants.ELEMENT_ELEMENT, 
				new String[][]{
					new String[] {"", ISMLConstants.SUBSTITUTIONGROUP_ATTRIBUTE, null},
					new String[] {"", ISMLConstants.NAME_ATTRIBUTE, null}}, 
				new String[]{
					ISMLConstants.NAME_ATTRIBUTE, ISMLConstants.SUBSTITUTIONGROUP_ATTRIBUTE});
    	}

	protected String getValueToStoreNS()
	{
		return super.getTargetNamespace();
	}    
	/**
     * @see org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractPropertyExtractor#getDataStructure()
     */
    public Map<String, Map<String, String>> getDataStructure()
    {    
    	return super.getMapDataStructure();
    }	
}
