/*******************************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.cosmos.rm.internal.validation.SMLActivator;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ConstraintNode;
import org.eclipse.cosmos.rm.internal.validation.artifacts.TargetElementNode;
import org.eclipse.cosmos.rm.internal.validation.common.ISMLConstants;
import org.eclipse.cosmos.rm.internal.validation.common.AbstractValidationOutput.ValidationMessage;
import org.eclipse.cosmos.rm.internal.validation.core.IFoundationBuilder;
import org.eclipse.cosmos.rm.internal.validation.util.ParserHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TargetInstanceBuilder extends AbstractDataBuilder<Map<TargetElementNode, String>>
{

	public static final String ID = SMLActivator.PLUGIN_ID + ".TargetInstanceBuilder";
    protected TargetElementNode currentTargetElement; 
    protected boolean uriElementFound = false; 	
    protected Map<TargetElementNode, String> dataStructure;
    protected Map<String, ConstraintNode> targetSchemaBuilderStructure;
    protected Map<String, Map<String, String>> substitionElementStructure;
	
	public TargetInstanceBuilder()
	{		
		dataStructure = new HashMap<TargetElementNode, String>();
		super.addEvent(IFoundationBuilder.EVENT_CHARACTER);
	}

	public Map<TargetElementNode, String> getDataStructure() {
		return dataStructure;
	}

	@SuppressWarnings("unchecked")
	public void startInstances() {
		IDataBuilder targetSchemaBuilder  = DataBuilderRegistry.instance().getDataStructureBuilder(TargetSchemaBuilder.ID);			
		targetSchemaBuilderStructure = (Map<String, ConstraintNode>)targetSchemaBuilder.getDataStructure();				
		IDataBuilder substitionElement  = DataBuilderRegistry.instance().getDataStructureBuilder(SubstitutionBuilder.ID);
		substitionElementStructure = (Map<String, Map<String, String>>)substitionElement.getDataStructure();
	}
	

	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException 
	{
		if (uri == null)
			return;
		
		ConstraintNode schemaNode = (ConstraintNode)targetSchemaBuilderStructure.get(localName);
		
		//check substitution group
		if (schemaNode == null){
			Map<String, String> subGroupMap = substitionElementStructure.get(uri);
			if (subGroupMap != null){
				String subGroup = subGroupMap.get(localName);
				if (subGroup != null)
					schemaNode = (ConstraintNode)targetSchemaBuilderStructure.get(ParserHelper.removeNameSpace(subGroup));
			}
		}
		//check if the element is defined as having a target element attribute and the ref:targetRequired is true and 
		if (schemaNode != null){
			currentTargetElement = new TargetElementNode(localName, getFilePath(), locator == null ? ValidationMessage.NO_LINE_NUMBER : locator.getLineNumber(), locator == null ? ValidationMessage.NO_LINE_NUMBER : locator.getColumnNumber());
			currentTargetElement.setUri(uri);
		}
		else if ((currentTargetElement != null) && (ISMLConstants.URI_ELEMENT.equals(localName))){
			uriElementFound = true;
		}
		else
			uriElementFound = false;
	}
	
	public void characters(char[] ch, int start, int len) throws SAXException {
		//extract the uri value
		if (uriElementFound){
			String target = new String(ch, start, len);
			dataStructure.put(currentTargetElement, target);
			String uri = currentTargetElement.getTargetURI();
			currentTargetElement.setTargetURI(uri == null ? target : uri+target);			
		}
	}	

	public void endElement(String uri, String localName, String qName) throws SAXException {
		if ((uriElementFound) && (ISMLConstants.URI_ELEMENT.equals(localName))){
			uriElementFound = false;
			currentTargetElement = null;
		}
	}

	public byte getPhase() {
		return ISMLConstants.INSTANCES_PHASE;
	}	

}
