/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.reference;

/**
 * This exception is thrown when there is an error in evaluating the 
 * expression that is to be evaluated.
 * 
 * @author Ali Mehregani
 */
public class BadExpressionException extends Exception
{
	/**
	 * The serial version UID
	 */
	private static final long serialVersionUID = 4184817679353869987L;

	/**
	 * Constructor
	 * 
	 * @param message A message indicating the error.
	 */
	public BadExpressionException(String message)
	{
		super(message);
	}
	
	/**
	 * Constructor
	 * 
	 * @param cause Wraps a throwable to indicate the cause
	 */
	public BadExpressionException(Throwable cause)
	{
		super(cause);
	}
}
