/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.reference;

import org.eclipse.cosmos.rm.internal.validation.artifacts.MappedNamespaceContext;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidationMessages;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.DataBuilderRegistry;
import org.eclipse.cosmos.rm.internal.validation.databuilders.NamespaceContextBuilder;
import org.eclipse.osgi.util.NLS;


/**
 * The XMLNS scheme is used to evaluate the parenthesized expressions that
 * appears after the keyword xmlns in an XPointer expression.
 * 
 * @author Ali Mehregani
 */
public class XmlnsScheme extends AbstractScheme
{
	/**
	 * Represents the keyword to identify this scheme
	 */
	public static final String SCHEME = "xmlns";


	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.reference.IXScheme#evaluate(java.lang.Object)
	 */
	public Object evaluate(Object context) throws BadExpressionException
	{
		MappedNamespaceContext namespaceContext = (MappedNamespaceContext)SMLValidatorUtil.retrieveDataStructure(NamespaceContextBuilder.ID);
		if (namespaceContext == null)
		{
			DataBuilderRegistry.instance().registerDataStructureBuilder(NamespaceContextBuilder.ID, new NamespaceContextBuilder());
			namespaceContext = (MappedNamespaceContext)SMLValidatorUtil.retrieveDataStructure(NamespaceContextBuilder.ID);			
		}
		
		/* Parse the expression */
		String expression = getExpression();
		int equalSignInx = -1;
		if (expression == null || (equalSignInx = expression.indexOf('=')) <= 0)
			throw new BadExpressionException (NLS.bind(SMLValidationMessages.errorBadNSExpression, expression));
		
		String prefix = expression.substring(0, equalSignInx);
		String uri = equalSignInx + 1 >= expression.length() ? null : expression.substring(equalSignInx + 1);
		
		if (prefix == null || (prefix = prefix.trim()).length() <= 0)
		{
			throw new BadExpressionException (NLS.bind(SMLValidationMessages.errorBadPrefix, expression));
		}
		else if (uri == null || (uri = uri.trim()).length() <= 0)
		{
			throw new BadExpressionException (NLS.bind(SMLValidationMessages.errorBadURI, expression));
		}
		
		namespaceContext.addEntry(prefix, uri);
		return context;
	}


	/**
	 * @see org.eclipse.cosmos.rm.internal.validation.reference.IXScheme#getType()
	 */
	public String getType()
	{
		return SCHEME;
	}

}
