/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;

public class SaverHelper {
    public static void saveQuery(String query, String uuid, String title, String nodeClass, String parentClass, String rootDir, boolean isFolder) throws Exception {
        String containerName = String.valueOf(rootDir) + File.separator + parentClass;
        File container = new File(containerName);
        container.mkdirs();
        File jprop = new File(String.valueOf(containerName) + File.separator + uuid + "." + "jprop");
        File queryFile = new File(String.valueOf(containerName) + File.separator + uuid + "." + "query");
        FileWriter writer = null;
        try {
            writer = new FileWriter(queryFile);
            writer.write(query);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        FileWriter jpropWriter = null;
        String jpropContent = "{nodeClass:\"" + nodeClass + "\", title:\"" + title + "\", services:\"__inherit__\", uuid:\"" + uuid + "\", isFolder:" + isFolder + "}";
        try {
            jpropWriter = new FileWriter(jprop);
            jpropWriter.write(jpropContent);
        }
        finally {
            if (jpropWriter != null) {
                jpropWriter.close();
            }
        }
    }

    public static void renameQuery(String uuid, String title, String nodeClass, String parentClass, String rootDir, boolean isFolder) throws Exception {
        String containerName = String.valueOf(rootDir) + File.separator + parentClass;
        File jprop = new File(String.valueOf(containerName) + File.separator + uuid + "." + "jprop");
        if (jprop.isFile()) {
            FileWriter jpropWriter = null;
            String jpropContent = "{nodeClass:\"" + nodeClass + "\", title:\"" + title + "\", services:\"__inherit__\", uuid:\"" + uuid + "\", isFolder:" + isFolder + "}";
            try {
                jpropWriter = new FileWriter(jprop);
                jpropWriter.write(jpropContent);
            }
            finally {
                if (jpropWriter != null) {
                    jpropWriter.close();
                }
            }
        }
    }

    public static File[] getSortedFileList(File dir, FilenameFilter filter) {
        File[] files = dir.listFiles(filter);
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return (int)(f2.lastModified() - f1.lastModified());
            }
        });
        return files;
    }

    public static void saveResponse(String response, String uuid, String rootDir, int limit) throws Exception {
        FilenameFilter filter;
        File[] children;
        String uuidDirname = String.valueOf(rootDir) + File.separator + "responses" + File.separator + uuid;
        File uuidDir = new File(uuidDirname);
        if (limit != -1 && uuidDir.isDirectory() && (children = SaverHelper.getSortedFileList(uuidDir, filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith("response");
            }
        })).length >= limit) {
            int childrenLength = children.length;
            if (limit > 0) {
                int x = limit - 1;
                while (x < childrenLength) {
                    children[x].delete();
                    ++x;
                }
            }
        }
        if (limit == 0) {
            return;
        }
        uuidDir.mkdirs();
        long timestamp = Calendar.getInstance().getTimeInMillis();
        File responseFile = new File(String.valueOf(uuidDirname) + File.separator + timestamp + "." + "response");
        FileWriter writer = null;
        try {
            writer = new FileWriter(responseFile);
            writer.write(response);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

