/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.XMLUtil;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.InternalUtility;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.ItemData;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.Messages;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class GraphResponseOutputter
extends AbstractOutputter {
    public static final String XMLXTREAM = "org.eclipse.cosmos.dr.drs.service.handler.xml.XMLStream";
    public static final String XML_NAMESPACE = "http://cmdbf.org/schema/1-0-0/datamodel";
    private StringBuffer DetailBuffer = null;
    private StringBuffer ARTBuffer = null;
    private Vector<ItemData> _nodes = null;
    private Vector<ItemData> _edges = null;
    protected static ILogger logger = LoggerWrapper.getLogger(GraphResponseOutputter.class);
    private InternalUtility ut = new InternalUtility();
    protected String rootId;
    protected String rootDir;

    public GraphResponseOutputter() {
        this.DetailBuffer = new StringBuffer();
        this.ARTBuffer = new StringBuffer();
        this._nodes = new Vector();
        this._edges = new Vector();
    }

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("queryRepository" + File.separator + "responses");
        super.initalize(context, parameters);
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String queryResponse = input.getParameter("queryResponse");
        String historyId = input.getParameter("historyId");
        String uuid = input.getParameter("uuid");
        if (historyId != null) {
            queryResponse = null;
            String historyFilename = String.valueOf(this.rootDir) + File.separator + uuid + File.separator + historyId + "." + "response";
            File file = new File(historyFilename);
            if (file.exists()) {
                StringBuffer buffer = new StringBuffer();
                FileInputStream fis = null;
                try {
                    int i;
                    fis = new FileInputStream(file);
                    while ((i = fis.read()) != -1) {
                        buffer.append((char)i);
                    }
                    fis.close();
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
                queryResponse = buffer.toString();
            }
        }
        if (queryResponse != null) {
            Element response = this.deserialize(queryResponse);
            GraphResponseOutputter local = new GraphResponseOutputter();
            local.render(output, response);
        }
    }

    protected Object getId(Object value) {
        return this.idResolver.getId(value);
    }

    public void render(PrintWriter output, Element response) throws CosmosException {
        StringBuffer buffer = new StringBuffer("{ items : [");
        buffer.append(this.renderElements(response));
        buffer.append("]}");
        output.println(buffer.toString());
    }

    public Element deserialize(String xmlString) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource s = new InputSource(new StringReader(xmlString));
        Document d = builder.parse(s);
        return d.getDocumentElement();
    }

    public void render(PrintWriter pw, InputSource input) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document d = builder.parse(input);
            Element el = d.getDocumentElement();
            StringBuffer buffer = new StringBuffer("{ items : [");
            buffer.append(this.renderElements(el));
            buffer.append("]}");
            pw.println(buffer.toString());
        }
        catch (CosmosException e) {
            logger.error(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
        }
    }

    protected StringBuffer renderElements(Element elem) throws CosmosException {
        StringBuffer buffer = new StringBuffer();
        StringBuffer fbuffer = new StringBuffer();
        NodeList nodes = elem.getElementsByTagNameNS(XML_NAMESPACE, "nodes");
        NodeList edges = elem.getElementsByTagNameNS(XML_NAMESPACE, "edges");
        fbuffer.append("{ Filter: 'All' }");
        this.ProcessNodes(nodes);
        this.ProcessEdges(edges);
        this.DumpNodesAndEdges(buffer);
        this.DumpFilterBuffer(fbuffer);
        buffer.append(fbuffer);
        buffer.append(this.DetailBuffer);
        buffer.append(this.ARTBuffer);
        return buffer;
    }

    protected boolean ProcessNodes(NodeList n) throws CosmosException {
        int i = 0;
        Element elem = null;
        i = 0;
        while (i < n.getLength()) {
            Node node = n.item(i);
            if (node.getNodeType() == 1) {
                elem = (Element)node;
                String t = elem.getAttribute("templateId");
                this.ProcessNode(elem, t);
            }
            ++i;
        }
        return n.getLength() > 0;
    }

    protected void ProcessNode(Element n, String templateId) throws CosmosException {
        NodeList items = n.getElementsByTagNameNS(XML_NAMESPACE, "item");
        Element item = null;
        int i = 0;
        i = 0;
        while (i < items.getLength()) {
            Node node = items.item(i);
            if (node.getNodeType() == 1) {
                item = (Element)node;
                this.ProcessItem(item, templateId, i == 0);
            }
            ++i;
        }
    }

    protected void EdgeInstance(Element item, ItemData I) {
        NodeList localId = null;
        NodeList Idl = null;
        NodeList mdrId = null;
        Node m = null;
        Node l = null;
        Element Id = null;
        String lidstr = null;
        String midstr = null;
        Idl = item.getElementsByTagNameNS(XML_NAMESPACE, "instanceId");
        if (Idl.getLength() > 0) {
            Id = (Element)Idl.item(0);
            localId = Id.getElementsByTagNameNS(XML_NAMESPACE, "localId");
            l = localId.item(0);
            lidstr = XMLUtil.extractText((Element)l);
            mdrId = Id.getElementsByTagNameNS(XML_NAMESPACE, "mdrId");
            m = mdrId.item(0);
            midstr = XMLUtil.extractText((Element)m);
            I.setMdrId(midstr);
            I.setEdgeId(lidstr);
        }
    }

    protected void ProcessItem(Element item, String templateId, boolean first) throws CosmosException {
        Node node;
        NodeList Idl = null;
        Node Id = null;
        NodeList records = null;
        Element record = null;
        NodeList arts = null;
        Element art = null;
        String tlidstr = null;
        String localId = null;
        int i = 0;
        boolean artdata = false;
        ItemData I = null;
        I = first ? new ItemData(templateId) : new ItemData();
        Idl = item.getElementsByTagNameNS(XML_NAMESPACE, "instanceId");
        if (Idl.getLength() > 0) {
            Id = Idl.item(0);
            if (Id.getNodeType() == 1) {
                localId = this.addNodeInstanceId(I, (Element)Id, templateId);
            }
        } else {
            CosmosException e = new CosmosException(Messages.getString("SpecViolation"));
            logger.error(e.getMessage(), e);
            throw e;
        }
        this.addMdrId(I, (Element)Id);
        I.setEdgeId("");
        I.setTLSID(this.ut.getTLID());
        tlidstr = new String(String.valueOf(templateId) + ":" + localId);
        this.ut.addTLIDMap(tlidstr);
        records = item.getElementsByTagNameNS(XML_NAMESPACE, "record");
        if (records != null) {
            i = 0;
            while (i < records.getLength()) {
                node = records.item(i);
                if (node.getNodeType() == 1) {
                    record = (Element)node;
                    this.addRecord(record, false);
                }
                ++i;
            }
        }
        if ((arts = item.getElementsByTagNameNS(XML_NAMESPACE, "additionalRecordType")) != null) {
            if (arts.getLength() == 0) {
                this.addArt(null, false);
            } else {
                i = 0;
                while (i < arts.getLength()) {
                    node = arts.item(i);
                    if (node.getNodeType() == 1) {
                        art = (Element)node;
                        artdata = true;
                        this.addArt(art, false);
                    }
                    ++i;
                }
            }
        } else {
            this.addArt(null, false);
        }
        this.ut.newTLID();
        I.setARTData(artdata);
        this._nodes.add(I);
    }

    public void addArt(Element art, boolean edge) {
        NodeList Id = null;
        Node n = null;
        String tmp = null;
        this.ARTBuffer.append(",");
        this.ARTBuffer.append("{ NameSpace:'");
        if (art != null) {
            Id = art.getElementsByTagNameNS(XML_NAMESPACE, "namespace");
            n = Id.item(0);
            tmp = XMLUtil.extractText((Element)n);
            this.ARTBuffer.append(tmp);
        }
        this.ARTBuffer.append("', LocalName:'");
        if (art != null) {
            Id = art.getElementsByTagNameNS(XML_NAMESPACE, "localName");
            n = Id.item(0);
            tmp = XMLUtil.extractText((Element)n);
            this.ARTBuffer.append(tmp);
        }
        if (edge) {
            this.ARTBuffer.append("', TLSID:'', TLTID:'', CosmosId: '" + this.ut.getCosmosId() + "' ");
        } else {
            this.ARTBuffer.append("', TLSID: '" + this.ut.getTLID() + "', TLTID:'', CosmosId:'' ");
        }
        this.ARTBuffer.append("}");
    }

    protected void addRecord(Element record, boolean edge) {
        NodeList Id = null;
        Node n = null;
        String tmp = null;
        if (this.DetailBuffer.length() > 0) {
            this.DetailBuffer.append(",");
        }
        this.DetailBuffer.append("{ recordId:");
        Id = record.getElementsByTagNameNS(XML_NAMESPACE, "recordId");
        n = Id.item(0);
        tmp = XMLUtil.extractText((Element)n);
        this.DetailBuffer.append("'" + tmp + "', LastModified:'',BaseLineId:'', SnapShortId:'',Detail:'");
        this.addContent(record);
        if (edge) {
            this.DetailBuffer.append("', TLSID:'', TLTID:'', CosmosId: '" + this.ut.getCosmosId() + "' ");
        } else {
            this.DetailBuffer.append("', TLSID: '" + this.ut.getTLID() + "', TLTID:'" + this.ut.getTLID() + "', CosmosId:'' ");
        }
        this.DetailBuffer.append("}");
    }

    protected void addContent(Element record) {
        int i = 0;
        NodeList l = record.getChildNodes();
        StringBuffer nb = new StringBuffer();
        String tmp = null;
        int idx = 0;
        i = 0;
        while (i < l.getLength()) {
            Node node = l.item(i);
            if (node.getNodeType() == 1) {
                try {
                    tmp = XMLUtil.xmlToString((Element)node);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                idx = tmp.indexOf(62);
                nb = new StringBuffer();
                nb.append(tmp.substring(idx += 2));
                this.TransformXML(nb);
                this.DetailBuffer.append(nb);
            }
            ++i;
        }
    }

    public void TransformXML(StringBuffer nb) {
        int i = 0;
        char[] ltb = new char[4];
        char[] gtb = new char[4];
        char[] hash = new char[3];
        char[] quot = new char[6];
        char[] amp = new char[5];
        ltb[0] = 38;
        ltb[1] = 108;
        ltb[2] = 116;
        ltb[3] = 59;
        gtb[0] = 38;
        gtb[1] = 103;
        gtb[2] = 116;
        gtb[3] = 59;
        amp[0] = 38;
        amp[1] = 97;
        amp[2] = 109;
        amp[3] = 112;
        amp[4] = 59;
        quot[0] = 38;
        quot[1] = 113;
        quot[2] = 117;
        quot[3] = 111;
        quot[4] = 116;
        quot[5] = 59;
        hash[0] = 37;
        hash[1] = 50;
        hash[2] = 51;
        i = 0;
        while (i < nb.length()) {
            if (nb.charAt(i) == '<') {
                nb.deleteCharAt(i);
                nb.insert(i, ltb);
            } else if (nb.charAt(i) == '\"') {
                nb.deleteCharAt(i);
                nb.insert(i, quot);
            } else if (nb.charAt(i) == '\u00a0') {
                nb.deleteCharAt(i);
                nb.insert(i, " ");
            } else if (nb.charAt(i) == '&') {
                nb.deleteCharAt(i);
                nb.insert(i, amp);
            } else if (nb.charAt(i) == '#') {
                nb.deleteCharAt(i);
                nb.insert(i, hash);
            } else if (nb.charAt(i) == '>') {
                if (i != nb.length() - 2 && (nb.charAt(i + 2) == '\n' || nb.charAt(i + 2) == '\r')) {
                    nb.deleteCharAt(i + 2);
                }
                if (i != nb.length() - 1 && (nb.charAt(i + 1) == '\n' || nb.charAt(i + 1) == '\r')) {
                    nb.deleteCharAt(i + 1);
                }
                nb.deleteCharAt(i);
                nb.insert(i, gtb);
            }
            ++i;
        }
        i = 0;
        while (i < nb.length()) {
            if (nb.charAt(i) == '\r') {
                nb.replace(i, i + 1, "\\n");
            } else if (nb.charAt(i) == '\n') {
                nb.replace(i, i + 1, "\\n");
            } else if (nb.charAt(i) == '\'') {
                nb.insert(i, "\\");
                ++i;
            }
            ++i;
        }
    }

    protected String addNodeInstanceId(ItemData I, Element Id, String templateId) {
        NodeList localId = null;
        NodeList mdrId = null;
        Node l = null;
        Node m = null;
        String tmp = null;
        String midstr = null;
        localId = Id.getElementsByTagNameNS(XML_NAMESPACE, "localId");
        l = localId.item(0);
        tmp = XMLUtil.extractText((Element)l);
        mdrId = Id.getElementsByTagNameNS(XML_NAMESPACE, "mdrId");
        m = mdrId.item(0);
        midstr = XMLUtil.extractText((Element)m);
        I.setSource(String.valueOf(templateId) + ":" + tmp);
        this.ut.addTemplateIdMap(templateId, midstr, tmp);
        return tmp;
    }

    protected void ProcessEdge(Element e, String templateId) {
        NodeList rs = e.getElementsByTagNameNS(XML_NAMESPACE, "relationship");
        Element r = null;
        int i = 0;
        i = 0;
        while (i < rs.getLength()) {
            Node node = rs.item(i);
            if (node.getNodeType() == 1) {
                r = (Element)node;
                this.ProcessRelationship(r, templateId, i == 0);
            }
            ++i;
        }
    }

    protected boolean ProcessEdges(NodeList e) {
        int i = 0;
        Element elem = null;
        i = 0;
        while (i < e.getLength()) {
            Node node = e.item(i);
            if (node.getNodeType() == 1) {
                elem = (Element)node;
                String t = elem.getAttribute("templateId");
                this.ProcessEdge(elem, t);
            }
            ++i;
        }
        return e.getLength() > 0;
    }

    protected void ProcessRelationship(Element r, String templateId, boolean first) {
        Node node;
        NodeList records = null;
        Element record = null;
        NodeList arts = null;
        Element art = null;
        NodeList sl = null;
        Node s = null;
        NodeList tl = null;
        Node t = null;
        int i = 0;
        String tlsid = null;
        String tltid = null;
        boolean artdata = false;
        ItemData I = null;
        I = first ? new ItemData(templateId) : new ItemData();
        sl = r.getElementsByTagNameNS(XML_NAMESPACE, "source");
        s = sl.item(0);
        if (s.getNodeType() == 1) {
            tlsid = this.addEdgeInstanceId(I, (Element)s, "Source", true);
        }
        I.setEdge(templateId);
        tl = r.getElementsByTagNameNS(XML_NAMESPACE, "target");
        t = tl.item(0);
        if (t.getNodeType() == 1) {
            tltid = this.addEdgeInstanceId(I, (Element)t, "Target", false);
        }
        I.setTLSID(Integer.valueOf(tlsid));
        I.setTLTID(Integer.valueOf(tltid));
        I.setCosmosId(this.ut.getCosmosId());
        this.EdgeInstance(r, I);
        records = r.getElementsByTagNameNS(XML_NAMESPACE, "record");
        if (records != null) {
            i = 0;
            while (i < records.getLength()) {
                node = records.item(i);
                if (node.getNodeType() == 1) {
                    record = (Element)node;
                    this.addRecord(record, true);
                }
                ++i;
            }
        }
        if ((arts = r.getElementsByTagNameNS(XML_NAMESPACE, "additionalRecordType")) != null) {
            if (arts.getLength() == 0) {
                this.addArt(null, true);
            } else {
                i = 0;
                while (i < arts.getLength()) {
                    node = arts.item(i);
                    if (node.getNodeType() == 1) {
                        art = (Element)node;
                        artdata = true;
                        this.addArt(art, true);
                    }
                    ++i;
                }
            }
        } else {
            this.addArt(null, true);
        }
        this.ut.newCosmosId();
        I.setARTData(artdata);
        this._edges.add(I);
    }

    protected String addEdgeInstanceId(ItemData I, Element Id, String prefix, boolean src) {
        NodeList localId = null;
        Node l = null;
        String tmp = null;
        NodeList mdrId = null;
        Node m = null;
        String midstr = null;
        String templateId = null;
        String tlidstr = null;
        localId = Id.getElementsByTagNameNS(XML_NAMESPACE, "localId");
        l = localId.item(0);
        tmp = XMLUtil.extractText((Element)l);
        mdrId = Id.getElementsByTagNameNS(XML_NAMESPACE, "mdrId");
        m = mdrId.item(0);
        midstr = XMLUtil.extractText((Element)m);
        templateId = this.ut.FindByValue(tmp, midstr);
        tlidstr = new String(String.valueOf(templateId) + ":" + tmp);
        if (src) {
            I.setSource(tlidstr);
        } else {
            I.setTarget(tlidstr);
        }
        return this.ut.MapTLID(tlidstr);
    }

    protected void addMdrId(ItemData I, Element Id) {
        NodeList mdrId = null;
        Node l = null;
        String tmp = null;
        mdrId = Id.getElementsByTagNameNS(XML_NAMESPACE, "mdrId");
        l = mdrId.item(0);
        tmp = XMLUtil.extractText((Element)l);
        I.setMdrId(tmp);
    }

    private void DumpNodesAndEdges(StringBuffer b) {
        this.FilterDupNodes();
        boolean c = this.DumpList(this._nodes, b, false);
        if (c) {
            b.append(",");
        }
        if (c = this.DumpList(this._edges, b, false)) {
            b.append(",");
        }
    }

    private void DumpFilterBuffer(StringBuffer b) {
        boolean n = this.DumpList(this._nodes, b, true);
        boolean e = this.DumpList(this._edges, b, true);
        if (e || n) {
            b.append(",");
        }
    }

    private boolean DumpList(Vector v, StringBuffer b, boolean filter) {
        boolean ret = false;
        Iterator I = null;
        ItemData d2 = null;
        for (ItemData d2 : v) {
            if (!filter && ret) {
                b.append(",");
            }
            if (filter) {
                if (!d2.PrintForFilter(b)) continue;
                ret = true;
                continue;
            }
            d2.Print(b);
            ret = true;
        }
        return ret;
    }

    private void FilterDupNodes() {
        Iterator<ItemData> e = null;
        ItemData d2 = null;
        ItemData nd = null;
        for (ItemData d2 : this._edges) {
            nd = this.CheckNodeList(d2.getSource());
            if (nd != null) {
                this._nodes.remove(nd);
            }
            if ((nd = this.CheckNodeList(d2.getTarget())) == null) continue;
            this._nodes.remove(nd);
        }
    }

    private ItemData CheckNodeList(String Id) {
        Iterator<ItemData> n = null;
        n = this._nodes.iterator();
        ItemData nd = null;
        while (n.hasNext()) {
            nd = n.next();
            if (!nd.getSource().equals(Id)) continue;
            return nd;
        }
        return null;
    }
}

