/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.ILogger;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.outputter.ReportElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class ReportDeploymentHandler
extends DefaultHandler {
    public static final String SAX_PARSER_FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String SAX_PARSER_FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String REPORT_ELEMENT = "report";
    public static final String TEMPLATE_ELEMENT = "template";
    public static final String FILE_ATTR = "file";
    public static final String ID_ATTR = "id";
    public static final String CAPTION_ATTR = "caption";
    public static final String TYPE_ATTR = "type";
    protected Map registry = new HashMap();
    protected Map templateLookup = new HashMap();
    protected ReportElement reportElem;
    private static ILogger logger = LoggerWrapper.getLogger(ReportDeploymentHandler.class);

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (REPORT_ELEMENT.equals(qName)) {
            this.reportElem = null;
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (REPORT_ELEMENT.equals(qName)) {
            this.reportElem = new ReportElement();
            this.reportElem.setType(attributes.getValue(TYPE_ATTR));
            this.registry.put(attributes.getValue(TYPE_ATTR), this.reportElem);
        } else if (TEMPLATE_ELEMENT.equals(qName) && this.reportElem != null) {
            this.reportElem.setFilename(attributes.getValue(FILE_ATTR));
            this.reportElem.setId(attributes.getValue(ID_ATTR));
            this.reportElem.setCaption(attributes.getValue(CAPTION_ATTR));
            this.templateLookup.put(this.reportElem.getId(), this.reportElem);
        }
    }

    public void parse(String filename) {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(false);
            saxParserFactory.setValidating(false);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.parse(new InputSource(new FileInputStream(new File(filename))), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            this.fatalError(e);
        }
        catch (SAXNotRecognizedException e) {
            this.fatalError(e);
        }
        catch (SAXNotSupportedException e) {
            this.fatalError(e);
        }
        catch (SAXException e) {
            this.fatalError(e);
        }
        catch (IOException e) {
            this.fatalError(e);
        }
    }

    protected void fatalError(Exception e) {
        logger.error(e.getMessage(), e);
    }

    public Map getRegistry() {
        return this.registry;
    }

    public Map getTemplateLookup() {
        return this.templateLookup;
    }
}

