/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.broker.provisional.datamodel;

import java.util.Iterator;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.eclipse.cosmos.dc.broker.provisional.datamodel.Services;

public class Group {
    private String host;
    private String name;
    private String description;
    private Services services = new Services();

    public String getHost() {
        return this.host == null ? null : this.host.trim();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getName() {
        return this.name == null ? null : this.name.trim();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description == null ? null : this.description.trim();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Services getServices() {
        return this.services;
    }

    public void setServices(Services services) {
        this.services = services;
    }

    public OMElement toOM() {
        String id = this.getHost();
        String desc = this.getDescription();
        String name = this.getName();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://www.eclipse.org/cosmos/broker", "tns");
        OMElement groupxml = fac.createOMElement("group", omNs);
        OMElement idxml = fac.createOMElement("host", omNs, (OMContainer)groupxml);
        OMElement descxml = fac.createOMElement("description", omNs, (OMContainer)groupxml);
        OMElement namexml = fac.createOMElement("name", omNs, (OMContainer)groupxml);
        fac.createOMText((OMContainer)idxml, id);
        fac.createOMText((OMContainer)descxml, desc);
        fac.createOMText((OMContainer)namexml, name);
        if (this.getServices() != null) {
            groupxml.addChild((OMNode)this.getServices().toOM());
        }
        return groupxml;
    }

    public static Group getGroup(OMElement groupxml) {
        Group group = new Group();
        Iterator groupIter = groupxml.getChildElements();
        while (groupIter.hasNext()) {
            OMElement elem = (OMElement)groupIter.next();
            if (elem.getLocalName().equals("host")) {
                group.setHost(elem.getText());
                continue;
            }
            if (elem.getLocalName().equals("name")) {
                group.setName(elem.getText());
                continue;
            }
            if (elem.getLocalName().equals("description")) {
                group.setDescription(elem.getText());
                continue;
            }
            if (!elem.getLocalName().equals("services")) continue;
            group.setServices(Services.getServices(elem));
        }
        return group;
    }
}

